<?php
include("slooze_local.php");
lang_init();
page_open(array("sess" => "Tof_Session",
				"auth" => "Tof_Auth")); 
snapshot('page_open');

function handleAction(&$render,&$tof,$vars) {
	$render->useCSS = false;
	$render->htmlTitle = "{$vars['action']} RPC";
	$render->scripts[] = "rpc.js";
	if (isset($vars['_RemoveID'])) {
		$render->startJavaScript();
		$render->show(
			"var elt = parent.document.getElementById('${vars['_RemoveID']}');\n".
			"if (elt) elt.parentNode.removeChild(elt);");
		$render->endJavaScript();
	}

	switch($vars['action']) {
		case 'addKeyword': {
			require_once("render/picture.php");
			showKeywords($render,$vars['PictureID']);
			$render->startJavaScript();
			$render->show("replaceElt('keywords'+${vars['PictureID']});");
			break; 
		}
		case 'addToFrontPage': {
			require_once("render/picture.php");
			showFrontPages($render,$vars['_PictureID']);
			$render->startJavaScript();
			$render->show("replaceElt('frontpages'+${vars['_PictureID']});");
			break; 
		}
		case 'showHideTopics': {
			require_once("render/topic.php");
			showShowHideTopics($render);
			$render->startJavaScript();
			if ($render->hideTopics) {
				$render->show("parent.document.getElementById('topics').style.display = 'none';");
			} else {
				$render->show("parent.document.getElementById('topics').style.display = 'block';");
			}
			$render->show("replaceEltText('showHideTopics');");
			break; 
		}
		case 'addPictureToTopic':
		case 'removePictureFromTopic': {
			require_once("render/nav.php");
			$topics = $tof->ct->getTopics($vars['PictureID'],$render->uid);
			showNavs($render,$topics);
			$render->startJavaScript();
			$render->show("replaceElt('topicsnav');");
			break; 
		}
		case 'updateTextElement': { 
			require_once("render/book.php");
			$text= $tof->ct->getTextElement($vars['TopicID'],$vars['PageNum'],$vars['Id']);

			showTextElement($render,$text);

			$render->show("<p onclick=\"replaceTextElement({$vars['PageNum']},{$vars['Id']});\">replace</p>");
			$render->includeJavaScript("script.js");
			$render->includeJavaScript("book.js");
			$render->startJavaScript();
			$data = addslashes($vars['Text']);
			$render->show(
				"window.parent.texts[${vars['PageNum']}][${vars['Id']}] =".
				" new Text(${vars['Id']},'$data',".
				"${vars['Top']},${vars['Left']},${vars['Bottom']},${vars['Right']},".
				"'${vars['Font']}',${vars['Size']},'${vars['Align']}');");
			$render->onload = "replaceTextElement({$vars['PageNum']},{$vars['Id']});";
			break;
		}
		case 'updateImageElement': {
			require_once("render/book.php");
			$image= $tof->ct->getImageElement($vars['TopicID'],$vars['PageNum'],$vars['Id']);
			showImageElement($render,$image);
			$render->includeJavaScript("script.js");
			$render->includeJavaScript("book.js");
			$render->startJavaScript();
			$render->show(
				"window.parent.images[${vars['PageNum']}][${vars['Id']}] =".
				" new Image(${vars['Id']},${vars['PictureID']},".
				"${vars['Top']},${vars['Left']},${vars['Bottom']},${vars['Right']},".
				"${vars['halign']},${vars['valign']});");
			$render->show("replaceImageElement({$vars['PageNum']},{$vars['Id']});");
			break;
		}
		default:
			$render->startJavaScript();			
	}

	$mem = makeSizeString(memory_get_usage());
	global $timer;
	$time = $timer->stopShow();
	$render->show("window.status='${vars['action']}: OK ($mem, ${time}s)';");
	$render->endJavaScript();
	$render->show("${vars['action']}: OK ($mem, ${time}s)");

	$render->showInHeader = true;
	$render->showHeader();

	echo $render->htmlHeader;
	echo $render->htmlStr;
	echo "</body></html>";
}

$tof = new MySlooze($auth->auth['uid']);
snapshot('new MySlooze');
$render = new BasicRender($tof);
snapshot('new BasicRender');
$tof->setRender($render);
if (isset($context))
	$render->context = $context;
$vars = $tof->validateInputs();
require_once("render/session.php");
updateSessionParameters($render,$vars);
$tof->handleAction($vars);
handleAction($render,$tof,$vars);
?>
