<?php
/************************************************************************/
/* giztimer.inc.php                                                        */
/* ===========================                                          */
/* Copyright (c) 2003 by David Rolston  (gizmo@gizmola.com)             */
/* http://www.gizmola.com                                               */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
//
// Credit to Brian Grayless for some of the ideas used in the class,
// particularly the Show_Timer() function, based on his note in the
// php.net microtime() manual page.
//
// Use:
// // Create a timer object.  At creation, Start time is recorded
// $t1 = new Giz_Timer();
// // When code or section of code is complete, stop the timer.
// $t1->Stop_Timer();
// // Display the Elapsed Time in seconds.  Defaults to 2 decimal places
// // or override the display by passing a parameter.
// $t1->Show_Timer(4);
/************************************************************************/
class Timer {
    var $starttime;
    var $endtime = 0;
	var $elapsedtime = 0;
	var $running = 0;
	var $last = 0;

    // Constructor.  
    // Purpose: Starts Timer.
	function Timer($start=true) {
		if ($start) {
			$this->starttime = microtime();
			$this->running = 1;
		} else {
			$this->running = 0;
		}
    }

	function start() {
		if ($this->running==0) {
			$this->starttime = microtime();
		}
		$this->running += 1;
	}

    // Member Function: Stop_Timer
    // Purpose: Stop Timing.
    function stop() {
		$this->running -= 1;
		if ($this->running==0) {
			$this->endtime = microtime();
			$this->last = $this->sub($this->endtime, $this->starttime);
			$this->elapsedtime += $this->last;
		}
	}

	/* t1 - t2 */
	function sub($t1, $t2) {
        list($usec1,$sec1) = explode(" ", $t1);
        list($usec2,$sec2) = explode(" ", $t2);
		$res = (float)$usec1 + (float)$sec1 - ((float)$usec2 + (float)$sec2);
		return $res;
	}

    // Member Function: Show_Timer
    // Purpose: Display elapsed time in seconds to precision passed in optional parameter
	function showValue($value,$decimals=3) {
        // $decimals will set the number of decimals you want for your milliseconds.
		// format start time
        $decimals = intval($decimals);
        if ($decimals > 8)
			$decimals = 8;
        if ($decimals < 0)
			$decimals = 0;
        return number_format($value, $decimals);
	}

	function showLast($decimals=3) {
		return $this->showValue($this->last,$decimals);
	}

	function show($decimals=3) {
		$elapsedtime = $this->elapsedtime;
		if ($this->running>0) {
			$elapsedtime += $this->sub(microtime(),$this->starttime);
		}
		return $this->showValue($elapsedtime,$decimals);
	}

	// Member Function: Stop_Show_Timer
    // Purpose: Stop the timer and Display elapsed time in seconds to precision passed in optional parameter
	function stopShow($decimals=3) {
		$this->stop();
		return $this->show($decimals);
	}
}
?>