/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_BASE_H
#define TOP10_BASE_H

#include "util/Dumpable.hh"
#include "Vertex.hh"

namespace top10 {
  namespace math {

    class Base: public top10::util::Dumpable
    {
    public:
      Vector x, y, z;
      Vector pos;

    public:
      Base(): x(1, 0, 0), y(0, 1, 0), z(0, 0, 1), pos(0, 0, 0) {}

      void pointTo(const Vector& direction, const Vector& up);

      void getToBase(double out[4][4]) const;

      void getFromBase(double out[4][4]);

      void rotateX(double angle);
      void rotateY(double angle);
      void rotateZ(double angle);

      void dumpTo(std::ostream&) const;
      void loadFrom(std::istream&);
    };
  };

};

#endif
