/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef SPRING_H
#define SPRING_H

#include <vector>

#include "Point.hh"
#include "util/Debug.hh"

#define NDEBUG

namespace top10 {
  namespace physX {

    /*!
     * A particular system of two points: a spring.
     * Also includes a shock absorber.
     */
    class Spring: private top10::util::Debug
    {
    public:
      /// References to end points
      Point* pts[2];

    public:
      /// pts[0] and pts[1] must be set before update is called
      Spring(const char* name = "Unnamed Spring", bool debug = 
#ifndef NDEBUG
	     true
#else
	     false
#endif
	     );

      Spring(Point* A, Point* B, const char* name = "Unnamed Spring",
	     bool debug =
#ifndef NDEBUG
	     true
#else
	     false
#endif
	     );

      // Strength
      double k;
      // original length
      double l;
      // resistance
      double f;

      inline Spring& operator=(const Spring& other) {
  	k = other.k;
  	l = other.l;
  	f = other.f;
  	return *this;
      }

    public:
      void update(double dt);

    private:
      /// old length - l
      /** We need this to avoid injecting energy into the system when
	  the spring oscillates around its rest position */
      double old_dlen;
    };

  };
};

#undef NDEBUG

#endif
