/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_DECORATIONSEDITOR_HH
#define TOP10_TRACKED_DECORATIONSEDITOR_HH

#include <string>
#include <set>
#include "Drawable.hh"
#include "MeshEditor.hh"

namespace top10 {
  namespace tracked {
    class DecorationsEditor : public Drawable {
    public:
      DecorationsEditor();
      void reset();
      inline void setMeshEditor(MeshEditor* p) { mesh_ed = p; }

      //! Pick the mesh under the reticle
      void pick();

      //! Set the current mesh using its name
      inline void setCurrent(std::string mesh_name) { current_mesh = mesh_name; }

      //! Get the name of the current mesh
      inline std::string getCurrent() const { return current_mesh; }

      //! Add the current mesh to the list of decorations
      void add();

      //! Remove the current mesh from the list of decorations
      void remove();

    public:
      std::set<std::string> decorations;

    protected:
      void drawGL_impl() const;

    private:
      std::string current_mesh;
      MeshEditor* mesh_ed;
    };
  };
};
#endif
