/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "MainEditor.hh"
#include <track/Track.hh>

using namespace top10::tracked;

MainEditor::MainEditor():
  mesh_ed(0), deco_ed(0), start_ed(0), cps_ed(0), surf_ed(0)
{
}

void MainEditor::loadTrack(std::string filename)
{
  assert(mesh_ed && deco_ed && start_ed && cps_ed && surf_ed);

  std::set<std::string> decorations, road, dusty, border, dirt, grass, sand;
  std::string mesh_name;
  top10::racing::StartingArea sa;
  top10::racing::CheckPoints cps;
  top10::math::AxisEnum axis;
  bool axis_neg;
  double scale;

  top10::track::loadTrackParts(filename, &mesh_name, &axis, &axis_neg, &scale,
			       &sa, &cps, &decorations, &road, &dusty, &border,
			       &dirt, &grass, &sand);

  mesh_ed->loadMesh(mesh_name);
  mesh_ed->axis = axis;
  mesh_ed->scaling = scale;
  mesh_ed->axis_negate = axis_neg;
  mesh_ed->reset();

  start_ed->starting_area = sa;

  cps_ed->checkpoints = cps;
  cps_ed->reset();

  deco_ed->decorations = decorations;
  deco_ed->reset();

  surf_ed->road_surfaces = road;
  surf_ed->dusty_road_surfaces = dusty;
  surf_ed->border_surfaces = border;
  surf_ed->dirt_surfaces = dirt;
  surf_ed->grass_surfaces = grass;
  surf_ed->sand_surfaces = sand;
  surf_ed->reset();
}

void MainEditor::saveTrack(std::string filename)
{
  assert(mesh_ed && deco_ed && start_ed && cps_ed && surf_ed);

  top10::track::saveMeshTrack(filename, mesh_ed->model_filename, mesh_ed->axis, mesh_ed->axis_negate, mesh_ed->scaling,
			      start_ed->starting_area,
			      cps_ed->checkpoints,
			      deco_ed->decorations,
			      surf_ed->road_surfaces, surf_ed->dusty_road_surfaces, surf_ed->border_surfaces,
			      surf_ed->dirt_surfaces, surf_ed->grass_surfaces, surf_ed->sand_surfaces);
}

void MainEditor::showEditorData(EditorEnum editor)
{
  switch(editor) {
  case Mesh:         mesh_ed->setVisible(true); break;
  case Decorations:  deco_ed->setVisible(true); break;
  case Surfaces:      surf_ed->setVisible(true); break;
  case StartingArea: start_ed->setVisible(true); break;
  case Checkpoints:  cps_ed->setVisible(true); break;
  }
}

void MainEditor::hideEditorData(EditorEnum editor)
{
  switch(editor) {
  case Mesh:         mesh_ed->setVisible(false); break;
  case Decorations:  deco_ed->setVisible(false); break;
  case Surfaces:      surf_ed->setVisible(false); break;
  case StartingArea: start_ed->setVisible(false); break;
  case Checkpoints:  cps_ed->setVisible(false); break;
  }
}
