/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_MESHEDITOR_HH
#define TOP10_TRACKED_MESHEDITOR_HH

#include <string>
#include <cassert>

#include "Drawable.hh"
#include "math/AxisEnum.hh"
#include "MainCamera.hh"
#include "ui_interactive/Triangle.hh"
#include "helpers/PolygonSet.hh"

namespace top10 {
  namespace tracked {
    class MeshEditor : public Drawable {
    public:
      MeshEditor();
      inline void setCamera(MainCamera* c) { camera = c; }

      void reset();

      /**
       * Load a mesh for the ground from a file
       * @param filename 
       */
      void loadMesh(std::string filename);

      std::string getPickedSurface() const;
      std::string getPickedMesh() const;
      top10::math::Vector getPickedPoint() const;

      inline       top10::ui_interactive::TriangleSet* getGLPolys()       { return gl_polys; }
      inline const top10::ui_interactive::TriangleSet* getGLPolys() const { return gl_polys; }

      inline       top10::helpers::PolygonSet* getPolys()       { return polys; }
      inline const top10::helpers::PolygonSet* getPolys() const { return polys; }

      //! Issue the OpenGL commands required to draw the track after transformations
      void setTransformGL() const;

    public:
      std::string model_filename;
      float scaling;
      top10::math::AxisEnum axis;
      bool axis_negate;

    protected:
      void drawGL_impl() const;

    private:
      top10::helpers::PolygonSet* polys;

      //! Used to draw the mesh representing the track
      top10::ui_interactive::TriangleSet* gl_polys;

      MainCamera* camera;
    };
  };
};

#endif

