/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include <cstdlib>

#include "DecorationsDialog.hh"
#include "DialogManager.hh"
#include "topListBox.hh"

#define LISTBOX_H0 (2*Dialog::H)
#define LISTBOX_H1 (7*Dialog::H)
#define LISTBOX_W  400

/*
 * Callbacks
 */

static void pick_cb(puObject* ob)
{
  DecorationsDialog* dialog = (DecorationsDialog*)ob->getUserData();
  dialog->getManager()->deco_ed->pick();
  dialog->getManager()->deco_ed->add();

  dialog->remove();
  dialog->install();
  dialog->show();
}

static void rem_cb(puObject* ob)
{
  try {
    DecorationsDialog* dialog = (DecorationsDialog*)ob->getUserData();
    dialog->getManager()->deco_ed->remove();
    
    dialog->remove();
    dialog->install();
    dialog->show();
  }
  catch (std::string e) {}
}

static void deco_cb(puObject* ob)
{
  DecorationsDialog* dialog = (DecorationsDialog*)ob->getUserData();
  int idx;
  ob->getValue(&idx);
  dialog->setCurrent(idx);
}

/*
 * Class implementation
 */
DecorationsDialog::DecorationsDialog(DialogManager* manager):
  Dialog(manager, "Decorations"), list_args(0), list_n(0)
{
}

void DecorationsDialog::populate()
{
  puOneShot* pick = new puOneShot(0, H, LISTBOX_W/2-5, 2*H);
  pick->setLegend("Pick");
  pick->setUserData(this);
  pick->setCallback(pick_cb);

  puOneShot* rem = new puOneShot(LISTBOX_W/2+5, H, LISTBOX_W, 2*H);
  rem->setLegend("Remove");
  rem->setUserData(this);
  rem->setCallback(rem_cb);

  if (!getManager()->deco_ed->decorations.empty()) {
    decos = new topListBox(0, LISTBOX_H0, LISTBOX_W, LISTBOX_H1, getManager()->deco_ed->decorations);
    decos->setUserData(this);
    decos->setCallback(deco_cb);
  }
}

void DecorationsDialog::setCurrent(int idx)
{
  getManager()->deco_ed->setCurrent(decos->getEntry(idx));
}
