/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_DIALOG_MANAGER_HH
#define TOP10_DIALOG_MANAGER_HH

#include <string>
#include "../MainEditor.hh"
#include "../MeshEditor.hh"
#include "../SurfacesEditor.hh"
#include "../DecorationsEditor.hh"
#include "../CheckpointsEditor.hh"
#include "../StartingAreaEditor.hh"

class Dialog;
class MasterDialog;

//! Class responsible for creating/deleting pui dialogs
class DialogManager
{
  friend class MasterDialog;

public:
  //! Exception thrown when a user tries to set the current dialog to an unregistered one.
  struct BadDialogName: public std::string
  {
    BadDialogName(std::string name): std::string(name) {}
  };

  struct AlreadyRegistered: public std::string
  {
    AlreadyRegistered(std::string name): std::string(name) {}
  };

public:
  DialogManager(top10::tracked::MainEditor*,
		top10::tracked::MeshEditor*,
		top10::tracked::SurfacesEditor*,
		top10::tracked::DecorationsEditor*,
		top10::tracked::CheckpointsEditor*,
		top10::tracked::StartingAreaEditor*);

  void registerDialog(Dialog*);

  //! Hide/show the current dialog
  void toggleActive();
  inline bool isActive() const { return active; }

  //! Set the current dialog
  void setCurrentDialog(std::string dialog_name);
  
public:
  top10::tracked::MainEditor* main_ed;
  top10::tracked::MeshEditor* mesh_ed;
  top10::tracked::SurfacesEditor* surf_ed;
  top10::tracked::DecorationsEditor* deco_ed;
  top10::tracked::CheckpointsEditor* cps_ed;
  top10::tracked::StartingAreaEditor* sa_ed;

private:
  typedef std::map<std::string, Dialog*> DialogRegister;

private:
  MasterDialog* master;
  DialogRegister dialogs;

  bool active;
  Dialog* current_dialog;
};

#endif
