/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "VisualDialog.hh"
#include "DialogManager.hh"

/*
 * Callbacks
 */

template<int N>
void radioCB(puObject* ob)
{
  VisualDialog* dialog = (VisualDialog*)ob->getUserData();

  int isSet;
  ob->getValue(&isSet);
  if (isSet)
    dialog->getManager()->main_ed->showEditorData(top10::tracked::toEditorEnum(N));
  else
    dialog->getManager()->main_ed->hideEditorData(top10::tracked::toEditorEnum(N));
}

/*
 * Class: VisualDialog
 */

VisualDialog::VisualDialog(DialogManager* manager):
  Dialog(manager, "Show/Hide data")
{
}

void VisualDialog::populate()
{
  puButton* mesh_radio =  new puButton(0, H, L_W, 2*H);
  mesh_radio->setLegend("Track Mesh");
  mesh_radio->setUserData(this);
  mesh_radio->setCallback(radioCB<top10::tracked::Mesh>);
  mesh_radio->setValue(getManager()->mesh_ed->isVisible());

  puButton* deco_radio =  new puButton(0, 2*H, L_W, 3*H);
  deco_radio->setLegend("Decorations");
  deco_radio->setUserData(this);
  deco_radio->setCallback(radioCB<top10::tracked::Decorations>);
  deco_radio->setValue(getManager()->deco_ed->isVisible());
  
  puButton* surf_radio =  new puButton(0, 3*H, L_W, 4*H);
  surf_radio->setLegend("Surface types");
  surf_radio->setUserData(this);
  surf_radio->setCallback(radioCB<top10::tracked::Surfaces>);
  surf_radio->setValue(getManager()->surf_ed->isVisible());

  puButton* start_radio = new puButton(0, 4*H, L_W, 5*H);
  start_radio->setLegend("Starting area");
  start_radio->setUserData(this);
  start_radio->setCallback(radioCB<top10::tracked::StartingArea>);
  start_radio->setValue(getManager()->sa_ed->isVisible());

  puButton* cps_radio =   new puButton(0, 5*H, L_W, 6*H);
  cps_radio->setLegend("Checkpoints");
  cps_radio->setUserData(this);
  cps_radio->setCallback(radioCB<top10::tracked::Checkpoints>);
  cps_radio->setValue(getManager()->cps_ed->isVisible());
}
