/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP_LISTBOX_HH
#define TOP_LISTBOX_HH

#include <plib/pu.h>
#include <set>
#include <string>

//! List box with vertical arrows and slider
class topListBox: public puListBox
{
public:
  topListBox(int x, int y, int maxx, int maxy, std::set<std::string> entries);

  ~topListBox();

  void goUp();
  void goDown();
  void go(float);

  inline std::string getEntry(int idx) const { return list_args[idx]; }

private:
  char **list_args;
  int list_n;
  puArrowButton* up;
  puArrowButton* down;
  puSlider* slider;
};

#endif
