/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "DecorationsDlg.hh"
#include <cassert>
#include <qmessagebox.h>
#include <qstring.h>
#include <qlistbox.h>

DecorationsDlg::DecorationsDlg(): deco_ed(0), viewer(0)
{
}

void DecorationsDlg::setCurrent(QListBoxItem* item)
{
  assert(deco_ed);
  assert(viewer);

  deco_ed->setCurrent(item->text().ascii());

  viewer->updateGL();
}

void DecorationsDlg::removeDeco()
{
  assert(deco_ed);
  assert(viewer);

  try {
    deco_ed->remove();
  }
  catch(std::string e) {
    QMessageBox::information(this, "Oops", e.c_str(), 1);
  }

  viewer->updateGL();
  update();
}

void DecorationsDlg::pickMesh()
{
  assert(deco_ed);
  assert(viewer);

  try {
    deco_ed->pick();
  }
  catch(std::string e) {
    QMessageBox::information(this, "Oops", e.c_str(), 1);
  }

  viewer->updateGL();
  update();
}

void DecorationsDlg::update()
{
  assert(deco_ed);

  DecoList->clear();
  for (std::set<std::string>::const_iterator it = deco_ed->decorations.begin();
       it != deco_ed->decorations.end();
       ++it) {
    DecoList->insertItem(it->c_str());
  }
}
