/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef MESH_DLG_HH
#define MESH_DLG_HH

#include "MeshDlgSkel.hh"
#include "../MeshEditor.hh"
#include "QGLView.hh"

class QString;

class MeshDlg: public MeshDlgSkel
{
public:
  MeshDlg();
  inline void setEditor(top10::tracked::MeshEditor* p) { mesh_ed = p; }
  inline void setViewer(QGLView* p) { viewer = p; }

  void selectFile();
  void setScale(const QString&);
  void setMeshFilename();
  void setAxis(int);
  void setNegative(int);

  void update();

private:
  top10::tracked::MeshEditor* mesh_ed;
  QGLView* viewer;
};

#endif
