/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Options.hh"

using namespace std;

int top10::ui_interactive::options::w(640);
int top10::ui_interactive::options::h(480);
int top10::ui_interactive::options::depth(16);
top10::ui_interactive::FFDevice* top10::ui_interactive::options::ffdev(0);
bool top10::ui_interactive::options::use_ff(false);
bool top10::ui_interactive::options::full_screen(false);
bool top10::ui_interactive::options::replay_from_file(false);
std::string top10::ui_interactive::options::replay_filename;
bool top10::ui_interactive::options::record_to_file(false);
std::string top10::ui_interactive::options::record_filename;
bool top10::ui_interactive::options::use_audio(true);
bool top10::ui_interactive::options::use_mouse(true);
std::string top10::ui_interactive::options::track_filename("mariembourg.trk");
std::string top10::ui_interactive::options::kart_filename;
double top10::ui_interactive::options::slow_factor(1.0);
bool top10::ui_interactive::options::physx_benchmark(false);

void top10::ui_interactive::options::parse(int argc, char** argv) throw(top10::util::Error)
{
  using top10::util::Error;
  using top10::ui_interactive;

  /* Parse command line */
  for (int i=1; i<argc; i++) {

    if (string(argv[i]) == string("-ff")) {
      use_ff = true;
    }

    else if (string(argv[i]) == string("-w")) {
      if (++i >= argc) {
	throw Error("Missing parameter to window width");
      }
      w = atoi(argv[i]);
    }

    else if (string(argv[i]) == string("-h")) {
      if (++i >= argc) {
	throw Error("Missing parameter to window height");
      }
      h = atoi(argv[i]);
    }

    else if (string(argv[i]) == string("-fs")) {
      full_screen = true;
    }

    else if (string(argv[i]) == string("-o")) {
      if (++i >= argc) {
	throw Error("Missing filename to record");
      }
      record_filename = string(argv[i]);
      record_to_file = true;
    }

    else if (string(argv[i]) == string("-i")) {
      if (++i >= argc) {
	throw Error("Missing filename to replay");
      }
      replay_filename = string(argv[i]);
      replay_from_file = true;
    }

    else if (string(argv[i]) == string("-ns")) {
      use_audio = false;
    }

    else if (string(argv[i]) == string("-nm")) {
      use_mouse = false;
    }

    else if (string(argv[i]) == string("-tf")) {
      if (++i >= argc) {
	throw Error("Missing track file to -tf");
      }
      track_filename = string(argv[i]);
    }

    else if (string(argv[i]) == "-kf") {
      if (++i >= argc) {
	throw Error("Missing file name to -kf");
      }
      kart_filename = string(argv[i]);
    }

    else if (string(argv[i]) == string("-bpp")) {
      if (++i >= argc) {
	throw Error("Missing depth to -bpp");
      }
      depth = atoi(argv[i]);
      if (depth == 0) {
	throw Error(string("Bad depth value ")+string(argv[i]));
      }
    }

    else if (string(argv[i]) == string("-sf")) {
      if (++i >= argc) {
	throw Error("Missing slow factor  to -sf");
      }
      slow_factor = atof(argv[i]);
      if (depth <= 0.0) {
	throw Error(string("Bad slow factor ")+string(argv[i]));
      }
    }

    else if (string(argv[i]) == string("-pb")) {
      physx_benchmark = true;
    }

    else {
      cout<<"Usage: "<<argv[0]<<" [-w <n>] [-h <n>] [-fs] [-nm] [-i <filename> | -o <filename>] [-pb] [-sf <x>] [-bpp <n>] [-kf <filename>] [-tf <track name>]"<<endl;
      throw Error("Bad option");
    }  
  }

  /* Check if we are not trying to replay and record at the same time */
  if (replay_from_file && record_to_file) {
    cout<<"At most one of -o or -i options can be specified"<<endl;
    throw Error("Cannot record and play at the same time");
  }
}
