/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_SOUND_BUFF_H
#define TOP10_SOUND_BUFF_H

#include "util/roundBuff.hh"
#include "util/error.hh"

namespace top10 {
  namespace ui_interactive {

    template<typename T>
    class SoundBuffer {
    public:
      DECL_ERROR(BadSamplingK);

    public:
      typedef T SampleT;

    public:
      SoundBuffer(top10::util::RoundBufferPtr<SampleT> buff):
	k(1.0),
	p(buff),
	frac(0.0)
      {
      }

      SoundBuffer(SampleT* start, int len):
	k(1.0),
	p(start, len),
	frac(0.0)
      {
      }

      void setSamplingK(double K)
      {
	if (K<1.0) throw BadSamplingK();
	k=K;
      }

      SampleT readNextSample()
      {
	double d_ret = *p * (1-frac); ++p;
	double k_remaining = k-(1-frac);
	while (k_remaining > 1.0) {
	  d_ret += *p; ++p;
	  k_remaining -= 1.0;
	}
	d_ret += *p * k_remaining;
	if (k_remaining == 1.0) {
	  ++p;
	  frac = 0.0;
	}
	else {
	  frac = k_remaining;
	}

	return (SampleT)(d_ret/k);
      }

    private:
      double k;
      top10::util::RoundBufferPtr<SampleT> p;
      double frac;
    };
  };
};

#endif
