/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef WET_NOTIFIER_HH
#define WET_NOTIFIER_HH

#include "YesNoMenu.hh"
#include "Simulation.hh"

namespace top10 {
  namespace ui_interactive {
    //! Tell a Simulation instance to modify its track grip factor
    class WetNotifier: public YesNoMenu::Notifier {
    public:
      WetNotifier(Simulation** sim_ptr_ref): sim(sim_ptr_ref) {}

      void yes() { if (*sim) (*sim)->setWet(true);  }
      void no()  { if (*sim) (*sim)->setWet(false); } 
      
    private:
      Simulation** sim;
    };
  };
};

#endif
