/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "initPaths.hh"
#include "util/PathFinder.hh"
#include "util/UserFile.hh"
#include <string>

// Preprocessor stringification magic...
#define xstr(s) str(s)
#define str(s) #s

void top10::ui_interactive::initPaths()
{
  std::string paths[] = {"data", xstr(DATA_DIR), ""};

  for (int i=0; !paths[i].empty(); ++i) {
    top10::util::PathFinder::addPath(paths[i]);
    top10::util::PathFinder::addPath(paths[i] +"/textures");
    top10::util::PathFinder::addPath(paths[i] +"/meshes");
    top10::util::PathFinder::addPath(paths[i] +"/tracks");
    top10::util::PathFinder::addPath(paths[i] +"/sounds");
    top10::util::PathFinder::addPath(paths[i] +"/karts");
    top10::util::PathFinder::addPath(paths[i] +"/fonts");
  }

  top10::util::PathFinder::addPath(top10::util::UserFile::getPath());
  top10::util::UserFile::makePath(); // Just in case it does not exist.

  for (int i=0; !paths[i].empty(); ++i) {
    top10::util::PathFinder::addPath("data/defaults");
  }
}
