/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "FreeCameraNode.hh"

namespace top10 {

namespace graphX {

FreeCameraNode::FreeCameraNode():
  angleY(0.0), angleX(0.0)
{
  update();  
}
  
void FreeCameraNode::rotateY(double degrees)
{
  angleY += degrees;
}

void FreeCameraNode::rotateX(double degrees)
{
  angleX += degrees;
}

void FreeCameraNode::translate(top10::math::Vector t)
{
  frustum.setCenter(frustum.getCenter()+t);
}

void FreeCameraNode::translateL(top10::math::Vector t)
{
  top10::math::Vector e0,e1,e2;
  e0 = frustum.getRight();
  e1 = frustum.getUp();
  e2 = -frustum.getDirection();
  top10::math::Matrix3 M3(e0,e1,e2);

  frustum.setCenter(frustum.getCenter() + M3*t);
}

void FreeCameraNode::zoom(double f)
{
  frustum.setFOV(frustum.getFOV() / f); 
  frustum.update();
}

void FreeCameraNode::update()
{
  using top10::math::Vector;

  double aX = angleX*M_PI/180.0;
  double aY = angleY*M_PI/180.0;
  double caY = cos(aY);
  double saY = sin(aY);

  Vector dir_flat(-saY, 0.0, -caY);
  Vector side_flat(caY, 0.0, -saY);
  
  Vector dir = cos(aX) * dir_flat + Vector(0, sin(aX), 0);
  Vector up = side_flat^dir;

  frustum.setDirection(dir, up);

  frustum.update();
}


}
}
