/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXFREECAMERANODE_HH
#define TOP10_GRAPHXFREECAMERANODE_HH

#include "CameraNode.hh"

namespace top10 {
namespace graphX {

//! Camera that can easily be incrementally translated and rotate around itself.
/*! It never tilts.
    This class is convenient to use in an editor when the user needs to easily move the camera around.
*/
class FreeCameraNode : public CameraNode
{
public:
  FreeCameraNode();

  //! Rotate around the vertical axis
  void rotateY(double degrees);
  //! Rotate around the lateral axis
  void rotateX(double degrees);
  //! Translate in the global coord system
  void translate(top10::math::Vector);
  //! Translate in the local coord system
  void translateL(top10::math::Vector);
  //! Zoom
  void zoom(double factor);
  //! Update the underlying frustum
  void update();

private:
  double angleY;
  double angleX;
};

}
}

#endif
