/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHX_MATERIALNODE_HH
#define TOP10_GRAPHX_MATERIALNODE_HH

#include "GroupNode.hh"

namespace top10 {
  namespace graphX {

    //! Material properties
    /*! Applies to all children */
    class MaterialNode: public GroupNode {
    public:
      MaterialNode(): r(0), g(0), b(0), glow_r(0), glow_g(0), glow_b(0) {}

    public:
      //! ambient and diffuse color
      unsigned char r,g,b;
      //! Emission (glow)
      unsigned char glow_r, glow_g, glow_b;

    protected:
      void modifyRenderState(RenderState& s) const {
        s.setColor(r,g,b);
        s.setGlow(glow_r, glow_g, glow_b);
      }
    };

  };
};

#endif
