/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHX_RENDERLIST_HH
#define TOP10_GRAPHX_RENDERLIST_HH

#include <map>
#include "RenderState.hh"
#include "util/RefCount.hh"

namespace top10 {
  namespace graphX {
    class Node;
    
    typedef std::multimap<RenderState, top10::util::Ref<const Node> > RenderList;
    
  };
};

void printOut(const top10::graphX::RenderList&);

#endif
