/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXRENDERER_HH
#define TOP10_GRAPHXRENDERER_HH

#include "RenderList.hh"
#include "RenderingFeatures.hh"

namespace top10 {
namespace graphX {

class CameraNode;

class Renderer {
public:
  Renderer();

  //! Set the current camera
  void setCamera(CameraNode*);
  CameraNode* getCamera() const;
  
  //! Clear the list of nodes to render
  void clearList();
  //! Build and sort the list of nodes to render
  void buildList(const Node*);
  //! Render the list, ignoring the position of the camera, but not the orientation.
  inline void renderSkyBoxGL() { renderCommon(Skybox); }
  //! Render the list
  inline void renderGL() { renderCommon(Scene); }
  //! Render a 2d HUD
  inline void renderHudGL() { renderCommon(Hud); }
  
  //! Initialize the OpenGL state.
  /*! \note must be called before rendering */
  void initGL(int width, int height);
  //! Clear all OpenGL buffers
  void clearAllGL();
  //! Clear the OpenGL depth buffer
  void clearDepthGL();
  //! Clear the color buffer
  void clearColorGL();
  //! Clear the stencil buffer
  void clearStencilGL();
  
  //! Enable or disable rendering to the color buffer
  void toggleColorRendering(bool b);
  //! Enable or disable writing into the depth buffer
  void toggleDepthRendering(bool b);
  void toggleDepthTest(bool b);
      
  //! Enables stencil tests, calls glStencilFunc
  void enableStencil(GLenum rel, GLint value);
  //! Specify what to do when the stencil and depth tests fail/succeed
  void setStencilOp(GLenum fail, GLenum zfail, GLenum zpass);
  void disableStencil();
  
  inline int getScreenWidth() const { return width; }
  inline int getScreenHeight() const { return height; }
  
private:
  RenderList rl;
  top10::util::Ref<CameraNode> camera;
  RenderingFeatures features;
  int width;
  int height;
      
  enum RenderMethod { Scene=0, Skybox, Hud };
  void renderCommon(RenderMethod);
};

};
};

#endif
