/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXSHADOWVOLUMENODE_HH
#define TOP10_GRAPHXSHADOWVOLUMENODE_HH

#include "LeafNode.hh"
#include "NodeProxy.hh"
#include "math/Outline.hh"

namespace top10 {
namespace graphX {

class ShadowVolumeNode : public LeafNode
{
public:
  class MyProxyOperation: public ProxyOperation
  {
  public:
    Node* makeChild(const MeshNode*) const;  
  };
  
public:
  ShadowVolumeNode(const top10::math::Mesh*);
  ~ShadowVolumeNode();

  void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const;
  void update(top10::math::Vector light_pos);
  
  static void recurseUpdate(top10::math::Vector light_pos, Node*, top10::math::Matrix4 M);
  static void recurseUpdate(top10::math::Vector light_pos, Node*);
  
private:
  top10::math::Outline outline;
  std::list<top10::math::Outline::Edge> edges;
  float* vertex_array;
  float* normal_array;
};

}
}

#endif
