/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "SkyBoxNode.hh"
#include "TextureManager.hh"

namespace top10 {
namespace graphX {

SkyBoxNode::SkyBoxNode()
{
  for (int i=0; i<6; ++i) {
    children[i] = new TransformNode;
    textures[i] = new TextureNode;
    textures[i]->filtering = RenderState::Trilinear;
    panels[i] = new PanelNode;
    
    children[i]->addChild(textures[i].getPtr());
    textures[i]->addChild(panels[i].getPtr());
  }

  double m[4][4] = {
    { 0, 0, 1, 0},
    { 0, 1, 0, 0},
    {-1, 0, 0, 0},
    { 0, 0, 0, 1}
  };
  
  top10::math::Matrix4 M(m);
  top10::math::Matrix4 T;
  T = top10::math::Identity4();
  
  for (int i=0; i<4; ++i) {
    children[i]->setToWorld(T);
    T = M*T;
  }
  
  double m2[4][4] = {
    {1, 0, 0, 0},
    {0, 0,-1, 0},
    {0, 1, 0, 0},
    {0, 0, 0, 1}
  };
  children[Top]->setToWorld(top10::math::Matrix4(m2));
  
  double m3[4][4] = {
    {1, 0, 0, 0},
    {0, 0, 1, 0},
    {0,-1, 0, 0},
    {0, 0, 0, 1}
  };
  children[Bottom]->setToWorld(top10::math::Matrix4(m3));

  textures[North]->texture_id = TextureManager::getInstance()->getTexture("Sunset/front.jpg");
  textures[West]->texture_id = TextureManager::getInstance()->getTexture("Sunset/left.jpg");
  textures[South]->texture_id = TextureManager::getInstance()->getTexture("Sunset/back.jpg");
  textures[East]->texture_id = TextureManager::getInstance()->getTexture("Sunset/right.jpg");
  textures[Top]->texture_id = TextureManager::getInstance()->getTexture("Sunset/top.jpg");
  textures[Bottom]->texture_id = TextureManager::getInstance()->getTexture("Sunset/bottom.jpg");
}

Node* SkyBoxNode::getChild(int idx) const
{
  if (idx>=0 && idx<6) return children[idx].getPtr();
  else return 0;
}

void SkyBoxNode::modifyRenderState(RenderState& s) const
{
  s.setColor(255, 255, 255);
}

}
}
