/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "SwitchNode.hh"
#include <algorithm>

namespace top10 {
namespace graphX {

SwitchNode::SwitchNode(int n_alts)
 : Node(), current(0), alts(n_alts)
{
}

Node* SwitchNode::getChild(int idx) const
{
  if (idx <0 || idx >= alts[current].size()) return 0;
  return alts[current][idx].getPtr();
}

void SwitchNode::addChild(Node* node)
{
  alts[current].push_back(top10::util::Ref<Node>(node));   
}

void SwitchNode::removeChild(Node* node)
{
  top10::util::Ref<Node> r(node);
  std::vector< top10::util::Ref<Node> >::iterator f = std::find(alts[current].begin(), alts[current].end(), r);
  if (f != alts[current].end()) alts[current].erase(f);
}

void SwitchNode::renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const
{ 
}
}
}
