/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "TextNode.hh"
#include "TextureManager.hh"
#include <sstream>
#include <plib/fnt.h>

namespace top10 {
namespace graphX {

TextNode::TextNode():
  pt_size(50.0),
  posx(0),
  posy(0),
  italic(false),
  font(0)
{
}

void TextNode::buildRenderList(RenderState s, RenderList* rl) const
{
  if (!font) return;
  
  s.setTextureId(TextureManager::other_textures_id);
  s.setColor(255, 255, 255);
  rl->insert(std::make_pair(s, this)); 
}

void TextNode::renderGL(const RenderingFeatures& features, const RenderState&, const CameraNode&) const
{
  if (!font) return;
#if 0
//  glDisable(GL_TEXTURE_2D);
//  glColor4f(1.0, 1.0, 1.0, 1.0);
  glBegin(GL_TRIANGLES);
  glVertex2f(posx, posy);
  glVertex2f(posx+pt_size, posy);
  glVertex2f(posx, posy+pt_size);
  glEnd();
#else  
  sgVec3 pos = {posx, posy, 0.0};
  font->begin();
  font->puts(pos, pt_size, italic?10.0:0.0, text.c_str());
  font->end();
#endif
}

void TextNode::setTime(unsigned int t)
{
  std::ostringstream buf;
  
  unsigned int ms = t % 1000;
  t/=1000;
  unsigned int s = t % 60;
  t/=60;
  unsigned int m = t;
  
  buf<<m<<":";
  if (s < 10) buf<<"0";
  buf<<s<<".";
  if (ms < 100) buf<<"0";
  if (ms < 10)  buf<<"0";
  buf<<ms;
  
  text = buf.str();
}

}
}
