/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_GRAPHXTEXTNODE_HH
#define TOP10_GRAPHXTEXTNODE_HH

#include "LeafNode.hh"

class fntFont;

namespace top10 {
namespace graphX {

class TextNode: public top10::graphX::LeafNode
{
public:
  TextNode();

  inline void setText(std::string txt) { text = txt;  }
  inline void setPointSize(float s)    { pt_size = s; }
  inline void setItalic(bool b)        { italic = b;  }
  inline void setFont(fntFont* f)      { font = f;    }
  inline void setPos(int x, int y)     { posx = x; posy = y; }    
  
  //! Set the text of the form m:ss:xxx
  void setTime(unsigned int t);
  
  void buildRenderList(RenderState s, RenderList* rl) const;
  void renderGL(const RenderingFeatures&, const RenderState&, const CameraNode&) const;
  
private:
  std::string text;
  int posx;
  int posy;
  float pt_size;
  bool italic;
  fntFont* font;
};

}
}

#endif
