/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Mesh.hh"
#include <cassert>

using namespace top10::math;

Mesh::Mesh()
{
}

void Mesh::addVertex(Vector v)
{
  vertices.push_back(v);    
}

void Mesh::addFace(unsigned int idx1, unsigned int idx2, unsigned int idx3)
{
  assert(idx1 < vertices.size() && idx2 < vertices.size() && idx3 < vertices.size());
  Face f = {idx1, idx2, idx3};
  faces.push_back(f);
}

void Mesh::addFace(unsigned int idx1, unsigned int idx2, unsigned int idx3, unsigned int idx4)
{
  assert(idx1 < vertices.size() && idx2 < vertices.size() && idx3 < vertices.size() && idx4 < vertices.size());
  Face f1 = {idx1, idx2, idx3};
  Face f2 = {idx3, idx4, idx2};
  
  faces.push_back(f1);
  faces.push_back(f2);
}

void Mesh::setVertices(const std::vector<Vector>& vs)
{
  assert(vertices.empty());
  vertices = vs;
}

void Mesh::setVertices(unsigned int n_vertices, Vector vs[])
{
  assert(vertices.empty());
  vertices.reserve(n_vertices);
  for (unsigned int i=0; i<n_vertices; ++i) vertices.push_back(vs[i]);
}

void Mesh::setVertices(unsigned int n_vertices, double vs[])
{
  assert(vertices.empty());
  vertices.reserve(n_vertices);
  double *p = vs;
  for (unsigned int i=0; i<n_vertices; ++i, p+=3) vertices.push_back(Vector(p[0], p[1], p[2]));
}

void Mesh::setVertices(unsigned int n_vertices, float vs[])
{
  assert(vertices.empty());
  vertices.reserve(n_vertices);
  float *p = vs;
  for (unsigned int i=0; i<n_vertices; ++i, p+=3) vertices.push_back(Vector(p[0], p[1], p[2]));
}

void Mesh::transform(const top10::math::Matrix4& M)
{
  for (std::vector<Vector>::iterator v_it = vertices.begin(); v_it != vertices.end(); ++v_it) {
    *v_it = M * (*v_it);
  }   
}

void Mesh::getVertexArray(unsigned int size, float array[])
{
  int i=0;
  for (std::vector<Face>::const_iterator face_it = faces.begin(); face_it != faces.end() && size>0; ++face_it) {
    assert(i<size);
    for (int j=0; j<3; ++j)
      for (int c=0; c<3; ++c)
      array[i++] = vertices[face_it->idxs[j]][c];
  }
}