/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_MATH_MESH_HH
#define TOP10_MATH_MESH_HH

#include "Vertex.hh"
#include "Matrix.hh"
#include <vector>

namespace top10 {
  namespace math {

    //! A math::Mesh is a collection of triangles
    class Mesh {
    public:
      //! Each triangle is described using 3 indices into a vertex array.
      struct Face {
	unsigned int idxs[3];
      };

      Mesh();
      
      inline const std::vector<Vector>* getVertices() const { return &vertices; }
      inline const std::vector<Face>* getFaces() const { return &faces; }

      //! Add a vertex
      void addVertex(Vector);
      
      //! Add a face described by three vertex indices into the vertex array
      void addFace(unsigned int idx1, unsigned int idx2, unsigned int idx3);

      //! Add two faces described by four indexes
      void addFace(unsigned int idx1, unsigned int idx2, unsigned int idx3, unsigned int idx4);
      
      //! Specify the vertex array
      void setVertices(const std::vector<Vector>&);
      void setVertices(unsigned int n_vertices, Vector vertices[]);

      //! Note: verts must have 3*n_vertices items
      void setVertices(unsigned int n_vertices, double verts[]);
      void setVertices(unsigned int n_vertices, float verts[]);

      //! Useful for openGL vertex arrays
      /*! The array must have 3*m_vertices items */
      void getVertexArray(unsigned int size, float array[]);
      
      void transform(const top10::math::Matrix4&);
      
    private:
      std::vector<Vector> vertices;
      std::vector<Face> faces;
    };
    
  };
};

#endif
