/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "Outline.hh"

namespace top10 {
namespace math {

const double Outline::EPS = 0.01;

Outline::Outline(const Mesh* m):mesh(m)
{
}

void Outline::incr(std::map<Edge, int>& m, Edge e)
{
  std::map<Edge, int>::iterator f = m.find(e);
  if (f == m.end()) m[e] = 1;
  else f->second++;
}

std::list<Outline::Edge> Outline::compute(Vector viewer) const
{
  /* Edges belonging to front faces
    The int counts the number of times an edge appears.
    If it appears only once in total, it belongs to the outline
  */
  std::map<Edge, int> front;
  // Edges belonging to back faces
  std::map<Edge, int> back;
  // Edges in the outline
  std::list<Edge> edges;

  const std::vector<Vector>* vertices = mesh->getVertices();
  const std::vector<Mesh::Face>* faces = mesh->getFaces();
  
  for (std::vector<Mesh::Face>::const_iterator face_it = faces->begin(); face_it != faces->end(); ++face_it) {
    // Vector from the viewer to a point of the face
    Vector v = vertices->at(face_it->idxs[0]) - viewer;
    double vs = v.size();
    // Compute normal to the face
    Vector n = (vertices->at(face_it->idxs[1]) - vertices->at(face_it->idxs[0])) ^
        (vertices->at(face_it->idxs[2]) - vertices->at(face_it->idxs[1]));
    double ns = n.size();
    double vn = v*n/(ns*vs);
    
    int i=2;
    int j=0;
    for (; j<3; ++j, ++i) {
      if (i == 3) i = 0;
#if 0      
      if (vn <= -EPS) incr(front, Edge(face_it->idxs[i], face_it->idxs[j]));
      if (vn >= EPS) incr(back, Edge(face_it->idxs[i], face_it->idxs[j]));
      if (vn < EPS && vn > -EPS) edges.push_back(Edge(face_it->idxs[i], face_it->idxs[j]));
#else
//      if (vn < 0) incr(front, Edge(face_it->idxs[i], face_it->idxs[j]));
      if (vn > 0) incr(back, Edge(face_it->idxs[i], face_it->idxs[j]));
#endif
    }
  }
  
  // Build the list of edges belonging to the outline
  std::map<Edge, int>::const_iterator i1, i2;
  i1 = front.begin();
  i2 = back.begin();
  while (i1 != front.end() && i2 != back.end()) {
    if (i1->first == i2->first) {
       if (i1->second == 1 && i2->second == 1)
         edges.push_back(i2->first);
      ++i1;
      ++i2;
    }
    else if (i1->first < i2->first) {
        if (i1->second == 1) {
          Edge e = i1->first;
          e.inverted = !i1->first.inverted;
          edges.push_back(e);
        }
      ++i1; 
    }
    else {
        if (i2->second == 1)
         edges.push_back(i2->first);
      ++i2;   
    }
  }

  for (;i1 != front.end(); ++i1) {
    if (i1->second == 1) {
      Edge e = i1->first;
      e.inverted = !i1->first.inverted;
      edges.push_back(e);       
    }
  }
  for (;i2 != back.end(); ++i2) {
     if (i2->second == 1)
      edges.push_back(i2->first);
  }

  return edges;    
}

}
}
