/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_MATHOUTLINE_HH
#define TOP10_MATHOUTLINE_HH

#include "Mesh.hh"
#include <list>
#include <map>

namespace top10 {
namespace math {

class Outline {
  static const double EPS;
  
public:
  struct Edge {
    Edge(unsigned int _p1, unsigned int _p2) {
      if (_p1 < _p2) { p1 = _p1; p2 = _p2; inverted = false; }
      else { p1 = _p2; p2 = _p1; inverted = true; }
    }
      
    inline bool operator<(Edge other) const {
      if (p1 < other.p1) return true;
      if (p1 > other.p1) return false;
      return p2 < other.p2;
    }
    
    inline bool operator==(Edge other) const {
      return p1 == other.p1 && p2 == other.p2;
    }
    
    unsigned int p1, p2;
    bool inverted;
  };

public:  
  Outline(const Mesh* mesh);

  //! Compute the outline of a mesh, as seen from a specified position
  /*! The position of the viewer is expressed in local coordinates */
  std::list<Edge> compute(Vector viewer) const;
  
  inline const Mesh* getMesh() const { return mesh; }
  
private:
  const Mesh* mesh;
  
  static void incr(std::map<Edge, int>& m, Edge e);
};

}
}

#endif
