/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef POINT_H
#define POINT_H

#include "util/Dumpable.hh"
#include "math/Vertex.hh"

#include <assert.h>

namespace top10 {
  namespace physX {
    using top10::math::Vector;

    class Point: public top10::util::Dumpable
    {
    public:
      Point(): mass(0) {}
      Point(double x, double y, double z, double w);
      Point(Vector pos, double m);

    public:
      double mass;
      Vector pos, next_pos, old_pos;
      Vector speed, next_speed;
      Vector accel;

      void integrate(double dt);
      void shift();
      void back();

      void dumpTo(std::ostream&) const;
      void loadFrom(std::istream&);
    };

    //! Output to a stream (human readable)
    std::ostream& operator<<(std::ostream&, const Point&);
  };

};
#endif
