/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_CHECKPOINT_HH
#define TOP10_CHECKPOINT_HH

#include <iostream>
#include <vector>

#include "math/Vertex.hh"
#include "math/Plane.hh"

namespace top10 {
  namespace ui_interactive {
        class Simulation;
  };

  namespace racing {

	using top10::math::Vector;
	using top10::math::Plane;

    /**
       A checkpoint is an area which racing vehicles must go throuh.
       A lap is completed when every checkpoint has been passed in the
       right order.
    */
    class CheckPoint {
    public:
      CheckPoint(double x1 =0, double z1 =0, double x2 =0, double z2 =1);
      CheckPoint(const Vector& a, const Vector& b);
    
      /**
	 Check if a segment crosses the checkpoint area.
	 \param old_pos position at last time step of moving object
	 \param new_pos position at current time step of moving object
	 \return true if checkpoint is passed by moving object
      */
      bool checkPassed(const Vector& old_pos, const Vector& new_pos) const;
    
      CheckPoint& operator=(const CheckPoint& other);

      friend std::istream& operator>>(std::istream&, CheckPoint&);
      friend std::ostream& operator<<(std::ostream&, const CheckPoint&);

      inline Vector getPoint1() const { return p1; }
      inline Vector getPoint2() const { return p2; }
      inline void setPoint1(Vector v) { p1 = v; }
      inline void setPoint2(Vector v) { p2 = v; }

    private:
      Vector p1;
      Vector p2;
      Plane plane;
    };

    class CheckPoints: public std::vector<CheckPoint>
    {
    public:
      CheckPoints(): std::vector<CheckPoint>() {}
    };

    std::istream& operator>>(std::istream&, CheckPoints&);
    std::ostream& operator<<(std::ostream&, const CheckPoints&);
  };
};

#endif
