/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "LapRecord.hh"

namespace top10 {
namespace racing {
  
KartState LapRecord::getKartState(unsigned int ts) const
{
  KartState ret;
  ret.orient = top10::math::Identity3();
  
  if (states.empty()) return ret;
  
  // Move hint to some position earlier than ts
  while (hint->timestamp > ts && hint != states.begin()) --hint;
  
  // "after" will point on the state with smallest timestamp above ts
  ContainerT::const_iterator after = hint;
  while (after->timestamp < ts && after != states.end()) {
    ++after;
  }
  if (after == states.end()) --after;
  hint = after;
  
  ContainerT::const_iterator before = after;
  if (before != states.begin()) --before;
  
  unsigned int dt = after->timestamp - before->timestamp;
  float x = (float)ts-before->timestamp;
  if (dt != 0) x /= dt;
  else x = 0.0;
  float y = 1.0-x;
  
  ret.steer = y*before->steer + x*after->steer;
  ret.orient = y*before->orient + x*after->orient;   // Linear interpolation of rotation matrices is not correct, but it looks ok.
  ret.timestamp = ts;
  ret.translation = y*before->translation + x*after->translation;
  
  return ret;
}
      
}
}