/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/


#ifndef TOP10_TRACKED_DRAWABLE_HH
#define TOP10_TRACKED_DRAWABLE_HH

#include "graphX/SwitchNode.hh"

namespace top10 {
  namespace tracked {

    class Drawable {
    public:
      Drawable(): switch_node(new top10::graphX::SwitchNode(2)), visible(false) { switch_node->enable(0); }

      inline top10::graphX::SwitchNode* getNode() const { return switch_node.getPtr(); }
      
      inline bool isVisible() const { return visible; }
      inline void setVisible(bool b) { visible = b; if (b) switch_node->enable(0); else switch_node->enable(1);}

    private:
      top10::util::Ref<top10::graphX::SwitchNode> switch_node;
      bool visible;
    };

  };
};

#endif

