/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "StartingAreaEditor.hh"

using namespace top10::tracked;

StartingAreaEditor::StartingAreaEditor():
  top_node(0),
  mesh_ed(0)
{
  top_node = new Node(this);
  getNode()->addChild(top_node.getPtr());
}

void StartingAreaEditor::pickLeft()
{
  assert(mesh_ed);

  top10::math::Vector p = mesh_ed->getPickedPoint();
  starting_area.setPoint1(p);
  setDirection();
}

void StartingAreaEditor::pickRight()
{
  assert(mesh_ed);

  top10::math::Vector p = mesh_ed->getPickedPoint();
  starting_area.setPoint2(p);
  setDirection();
}

void StartingAreaEditor::swap()
{
  top10::math::Vector tmp = starting_area.getPoint1();
  starting_area.setPoint1(starting_area.getPoint2());
  starting_area.setPoint2(tmp);
  setDirection();
}

void StartingAreaEditor::setDirection()
{
  top10::math::Vector dir = (starting_area.getPoint1() - starting_area.getPoint2())^top10::math::Vector(0,1,0);
  double s = dir.size();
  if (s < SMALL_VECTOR) throw std::string("Left and right points cannot be aligned vertically");
  dir /= s;
  starting_area.setDirection(dir);
}

void StartingAreaEditor::Node::renderGL(const top10::graphX::RenderingFeatures&,
  const top10::graphX::RenderState&,
  const top10::graphX::CameraNode&) const
{
  using top10::math::Vector;
  using top10::racing::StartingArea;

  Vector p = ed->starting_area.getPoint1();
 
  glBegin(GL_LINE_STRIP);
  glVertex3f(p.x, p.y, p.z);
  p -= 5*ed->starting_area.getDirection();
  glVertex3f(p.x, p.y, p.z);
  p = ed->starting_area.getPoint2();
  p -= 5*ed->starting_area.getDirection();
  glVertex3f(p.x, p.y, p.z);
  p = ed->starting_area.getPoint2();
  glVertex3f(p.x, p.y, p.z);
  glEnd();
}
