/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "SurfaceTypeProxyNode.hh"
#include "graphX/MaterialNode.hh"

namespace top10 {
namespace tracked {

// Road, DustyRoad, Border, Grass, Sand, Dirt
const unsigned char SurfaceTypeProxyOperation::rs[6] = {160, 100, 255,   0, 255, 127};
const unsigned char SurfaceTypeProxyOperation::gs[6] = {160, 100,   0, 255, 255,   0};
const unsigned char SurfaceTypeProxyOperation::bs[6] = {160, 100,   0,   0,   0,   0};

top10::graphX::Node* SurfaceTypeProxyOperation::makeChild(const top10::graphX::MeshNode* n) const
{
  top10::graphX::MaterialNode* ret = new top10::graphX::MaterialNode;
  ret->addChild(const_cast<top10::graphX::MeshNode*>(n));
      
#define COMPARE_AND_ASSIGN(attr, idx)\
if (surf_ed->attr.find(n->getMaterialName()) != surf_ed->attr.end()) { ret->r = rs[idx]; ret->g = gs[idx]; ret->b = bs[idx]; }

  COMPARE_AND_ASSIGN(road_surfaces, 0)
  else COMPARE_AND_ASSIGN(dusty_road_surfaces, 1)
  else COMPARE_AND_ASSIGN(border_surfaces, 2)
  else COMPARE_AND_ASSIGN(grass_surfaces, 3)
  else COMPARE_AND_ASSIGN(sand_surfaces, 4)
  else COMPARE_AND_ASSIGN(dirt_surfaces, 5)
  else { ret->r = ret->g = ret->b = 255; }
#undef COMPARE_AND_ASSIGN

  return ret;
}

}
}
