/*
  Top10, a racing simulator
  Copyright (C) 2000-2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Dialog.hh"
#include "DialogManager.hh"

int Dialog::screen_w = 800;
int Dialog::screen_h = 600;

static void back_cb(puObject* ob)
{
  ((DialogManager*)ob->getUserData())->setCurrentDialog("Master");
}

Dialog::Dialog(DialogManager*m, std::string n): manager(m), name(n), top(0)
{
  m->registerDialog(this);
}

void Dialog::install() {
  top = new puGroup(0,0);
  populate();

  // If this is a registered dialog, add a button to go back the master dialog
  if (getManager()) {
    puOneShot* back = new puOneShot(0,0, " <- ");
    back->setUserData(getManager());
    back->setCallback(back_cb);
  }

  top->close();

  // Center the puGroup
  puBox* bbox = top->getBBox();
  top->setPosition((screen_w - bbox->max[0])/2, (screen_h - bbox->max[1])/2);
}
