/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UI_INTERACTIVEGAMEMANAGER_HH
#define TOP10_UI_INTERACTIVEGAMEMANAGER_HH

#include "Controls.hh"
#include "audio.hh"
#include "Simulation.hh"
#include "graphX/SkyBoxNode.hh"
#include "graphX/TransformNode.hh"
#include "graphX/Renderer.hh"
#include "graphX/FreeCameraNode.hh"
#include "graphX/TextNode.hh"
#include "graphX/AlphaNode.hh"
#include "track/Track.hh"
#include "util/RefCount.hh"

#include <string>

namespace top10 {
namespace ui_interactive {

class GameManager
{
public:
  static const unsigned char hud_opacity = 250;
  
  GameManager(top10::graphX::Renderer* render, AudioDevice* audio);
  
  void createTrainingSession(std::string track_name, std::string kart_model, bool rainy_weather);
  void createRace(std::string track_name, std::string kart_model, bool rainy_weather);
  void startGame();
  void updateGame();
  void terminateGame();
    
  void sendEvent(Action, Sint16 value);

  //! Switch to the next camera
  void nextCamera();
  //! Switch to the previous camera
  void prevCamera();
  //! Switch to the same camera on the next kart
  void nextKart();
  //! Switch to the same camera on the previous kart
  void prevKart();
  //! Allow access to the free camera
  inline top10::graphX::FreeCameraNode* freeCamera() { return free_camera.getPtr(); }
  inline void toggleFreeCamera() { use_freecam = !use_freecam; }
  
  top10::graphX::CameraNode* getCamera();
  void renderGL();
  
private:
  top10::graphX::Renderer* render;
  AudioDevice* audio;
  fntFont* font;
  unsigned int time_start;
  unsigned int last_update;
  bool started;
  bool ghost_hidden;
  
  top10::util::Ref<Simulation> simulation;
  top10::util::Ref<top10::track::Track> track;
  top10::util::Ref<KartNode> kart_model;
  
  top10::util::Ref<top10::graphX::SkyBoxNode> skybox;
  top10::util::Ref<top10::graphX::GroupNode> track_and_karts;
  top10::util::RefArray<top10::graphX::TransformNode> karts;
  top10::util::RefArray<KartNode> kart_nodes;
  
  top10::util::Ref<top10::graphX::AlphaNode> ghost_alpha;
  top10::util::Ref<top10::graphX::TransformNode> ghost_trans;
  top10::util::Ref<KartNode> ghost;
  
  top10::util::Ref<top10::graphX::Node> hud;
  top10::util::Ref<top10::graphX::TextNode> current_time;
  top10::util::Ref<top10::graphX::TextNode> best_time;
  top10::util::Ref<top10::graphX::TextNode> last_time;
  
  top10::util::Ref<top10::graphX::GroupNode> shadows;
  
  //! Camera useful for debuging
  top10::util::Ref<top10::graphX::FreeCameraNode> free_camera;
  
  //! Index of the kart whose camera is being the active one
  int camera_kart;
  //! Index of the camera
  int camera;
  bool use_freecam;
  
  top10::math::Matrix4 getKartTransform(top10::racing::KartState s) const;
  top10::math::Matrix4 getKartTransform(const Kart*) const;
};

}
}

#endif
