/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "Options.hh"
#include "util/GlobalOptions.hh"

using namespace std;

int top10::ui_interactive::options::w(0);  // Take value from the options files
int top10::ui_interactive::options::h(0);
top10::ui_interactive::FFDevice* top10::ui_interactive::options::ffdev(0);
bool top10::ui_interactive::options::use_ff(false);
bool top10::ui_interactive::options::full_screen(true);
bool top10::ui_interactive::options::use_audio(true);
std::string top10::ui_interactive::options::kart_filename;
double top10::ui_interactive::options::slow_factor(1.0);

void top10::ui_interactive::options::parse(int argc, char** argv) throw(top10::util::Error)
{
  using top10::util::Error;

  w = getOptI("Render.Window.Width");
  h = getOptI("Render.Window.Height");
  full_screen = getEnabledOpt("Render.Window.Fullscreen");
  
  /* Parse command line */
  for (int i=1; i<argc; i++) {

    if (string(argv[i]) == string("-ff")) {
      use_ff = true;
    }

    else if (string(argv[i]) == string("-w")) {
      if (++i >= argc) {
	      throw Error("Missing parameter to window width");
      }
      w = atoi(argv[i]);
    }

    else if (string(argv[i]) == string("-h")) {
      if (++i >= argc) {
	      throw Error("Missing parameter to window height");
      }
      h = atoi(argv[i]);
    }

    else if (string(argv[i]) == string("-nofs")) {
      full_screen = false;
    }

    else if (string(argv[i]) == string("-nosnd")) {
      use_audio = false;
    }

    else if (string(argv[i]) == "-kf") {
      if (++i >= argc) {
	      throw Error("Missing file name to -kf");
      }
      kart_filename = string(argv[i]);
    }

    else if (string(argv[i]) == string("-sf")) {
      if (++i >= argc) {
      	throw Error("Missing slow factor  to -sf");
      }
      slow_factor = atof(argv[i]);
      if (slow_factor <= 0.0) {
	      throw Error(string("Bad slow factor ")+string(argv[i]));
      }
    }

    else {
      cout<<"Usage: "<<argv[0]<<" [-w <n>] [-h <n>] [-nofs] [-nosnd] [-sf <x>] [-kf <filename>]"<<endl;
      throw Error("Bad option");
    }  
  }
}
