/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef YESNO_MENU_HH
#define YESNO_MENU_HH

namespace top10 {
  namespace ui_interactive {

    class YesNoMenu: public UIPanel::Menu {
    public:

      //! Interface of classes handling yes/no choices
      class Notifier {
      public:
	virtual void yes()=0;
	virtual void no()=0;

	virtual ~Notifier() {}
      };

      //! Implementation of Notifier setting a boolean variable
      class BoolNotifier: public Notifier {
      public:
	BoolNotifier(bool* b): var(b) {}
	void yes() { *var = true; }
	void no()  { *var = false; }

      private:
	bool* var;
      };

    public:
      YesNoMenu(UIPanel* p, Notifier* n): UIPanel::Menu(p), notifier(n) {
	entries.push_back("Yes");
	links.push_back(0);
	entries.push_back("No");
	links.push_back(0);
      }
      
      void selected() {
	if (getEntryN() == 0) notifier->yes();
	else notifier->no();
	panel->hide();
      }
      
    private:
      Notifier* notifier;
    };
  };
};

#endif
