#include "Parse.hh"
#include <iostream>
#include <string>
#include "util/error.hh"


std::string top10::util::parseString(std::istream& in)
{
  std::string s;
  char c;
  bool use_quotes;

  // Skip white spaces
  for (in.read(&c, 1); (c==' ' || c=='\t' || c=='\n'); in.read(&c, 1)) {
    if (in.eof()) return s;
  }

  if (c == '\"') {use_quotes = true;}
  else {use_quotes=false; s += c;}

  for (in.read(&c, 1); !((use_quotes && c=='\"') || (!use_quotes && (c==' ' || c=='\t' || c=='\n')));
       in.read(&c, 1)) {
    s += c;
    if (in.eof() && use_quotes) throw Error("Unterminated quote string");
  }

  return s;
}
