/* {{{1 GNU General Public License

sofea - the Stack Operated Finite Element Analysis program
Copyright (C) 2004  Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */
#include <stdio.h>
#include <stk.h>
#include <main.h>
#include <inpo.h>
#include <sparse.h>

int write_modeshape()   /* ( hV --- ) {{{1 */
/*
 * man entry:  write_modeshape {{{2
 * ( hV --- ) Write the vector to an ascii file.
 * category: FEA
 * related: sparse, element_matrix, fea_assemble
 * 2}}}
 */
{
int DEBUG = 1;

    int     i, size;
    double *vector;
#define size_T 160
    char    T[size_T+1];

if (DEBUG) printf("at top of write_modeshape\n");
    if (tos->typ != MAT) {
        stkerr(" write_modeshape:  Vector ", MATNOT);
        return 0;
    }
    vector = tos->mat;

    size = tos->row*tos->col;
    for (i = 0; i < size; i++) {
        printf("% 22.16e\n", vector[i]); 
    }
    fflush(stdout);

    /*
    drop();
    */
    return 1;

} /* 1}}} */
