/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* net.h December 2001

Copyright (c) 2001  D. R. Williamson

Words for networks.

References:
   1. Stevens, W. R., "UNIX Network Programming Volume 1, Networking
      APIs: Sockets and XTI," second edition, Prentice Hall, 1998.
   2. Stevens, W. R., "UNIX Network Programming Volume 2, Inter-
      process Communications," second edition, Prentice Hall, 1999.

Source code for all examples in References 1 and 2 can be obtained 
from: http://www.kohala.com/start/unpv12e.html

----------------------------------------------------------------------*/

#ifndef _NET_H
   #define _NET_H 1
#endif

#undef  __USE_POSIX
#define __USE_POSIX /* for signal.h, GNU C */

#undef  _XOPEN_SOURCE_EXTENDED
#define _XOPEN_SOURCE_EXTENDED 1 /* 1 for AIX */

#undef  __EXTENSIONS__
#define __EXTENSIONS__ /* for signal.h, Sun */

#include <signal.h>

#ifndef SA_SIGINFO
   #include <bits/sigaction.h>
#endif

/*----------------------------------------------------------------------

Most of this group of includes is from file unp.h of Reference 1: */

#ifndef __USE_BSD
   #define __USE_BSD
#endif

#undef __daddr_t_defined /* cause types.h to create typedef __caddr_t */
#include <sys/types.h>   /* basic system data types */

#include <sys/socket.h>  /* basic socket definitions */

#ifdef HAVE_SOCKADDR_DL_STRUCT
   #include <net/if_dl.h>
#endif
#include <sys/un.h>      /* for Unix domain sockets */

#include <sys/time.h>    /* timeval{} for select() */
#include <time.h>        /* timespec{} for pselect() */
#include <netinet/in.h>  /* sockaddr_in{}, other Internet defs */
#include <arpa/inet.h>   /* inet(3) functions */
#include <errno.h>
#include <fcntl.h>       /* for nonblocking */
#include <netdb.h>
#include <sys/stat.h>    /* for S_xxx file mode constants */
#include <sys/uio.h>     /* for iovec{} and readv/writev */

#undef _XOPEN_SOURCE_EXTENDED
#define _NO_PROTO
#include <unistd.h>
#include <sys/wait.h>

/* Following could be derived from SOMAXCONN in <sys/socket.h>, but many
   kernels still #define it as 5, while actually supporting many more */
/* [In GNU C Library, RH 7.2: <bits/socket.h> has SOMAXCONN=128 (drw)]*/

/*--------------------------------------------------------------------*/

typedef void    Sigfunc(int);   /* for signal handlers */

#define LISTENQ 1024    /* 2nd argument to listen() */
#define SERV_PORT 9877  /* default port number */

int BLOCKED;    /* 1 when select() services only SO_PEND */
int COG;        /* 1 for server to cog in sizes of READ_F bytes */
int DSERVER;    /* 1 if running a daemon server (SERVER also = 1) */
int HOLD;       /* equals 1 to continue blocking for SO_PEND services */
int LOCK_PEND;  /* lock is pending, probably for blocking */
int MAXBLOCK;   /* max seconds to wait for SO_PEND read */
int NET_ENDIAN; /* endian for transmitting 8-byte fp numbers */
int PORT;       /* server PORT number if local server is running */
int READ_F;     /* when not 0, limit bytes per FOREIGN read */
int READY;      /* equals 1 if server is ready */
double REMOTERUN_DELAY; /* delay in remoterun() after netvolwrite() */
int SERVER;     /* equals 1 if server is listening */
int SO_PEND;    /* the socket descriptor with a pending read enable */
int SOCKFD;     /* socket fd at current run level */

#define MAXROWS 1000000 /* max VOL rows read from socket in term.c */
#define PROMPT_WAIT 30 /* seconds to block for socket read at remote 
                          prompter */
#define R_WAIT  3 /* sec to block for socket to become readable */
#define uR_WAIT 0 /* usec to block for readable socket
                     warning: max(uR_WAIT)=999,999 microsec (AIX) */

/* Compiler option IPLOCAL for server() in term.c:
      0 - STR or VOL given to word SERVER or DSERVER contains a list 
          of the only IP addresses that will be allowed to connect
      1 - conventional TCP/IP operation with given IP address STR */
#define IPLOCAL 0

/* Default order for transmitting 8-byte fp numbers is little endian: */
#define NET_ENDIAN_DEF 1234

/* Since all instances of this program can run word SERVER and become a
   listening server on various machines, when a connection between two 
   of them is made there needs to be a definition of which one is the 
   client and which one is the server.  This is the definition:

      The one initiating the connection (through function CONNECT()) 
      is the client.

      The one receiving the connection is the server (in term.c, func-
      tion terminal() calling function Accept() and registering a new 
      client).

   Use of the terms remote and local:

      A remote client is one that connected to this local program while
      the local program was running SERVER on this machine.
      Remote clients can connect only when the local program is running
      SERVER to listen.

      A local client is running this program on this machine and is con-
      nected to a remote program.
      Local clients connect to remote servers, and the local SERVER of 
      the program may not be listening.

   Types at the two ends of a connection or socket:  

      Types LOCLI (local client) and LOSERV (local server) apply to 
      this program running on both ends, where type LOSERV is the name 
      at the end that is the server. 

      Type NATIVE is this program connected as a client to a remote 
      server that is not this program.

      Type FOREIGN is this program acting as server and connected to a
      remote client that is not this program.

      Type NEWCLI has just connected to the listening port of this pro-
      gram's SERVER, and if NEWCLI sends any bytes, it soon will be de-
      termined in function drainf() if this end of the connection is 
      type LOSERV (the remote client is also running this program) or 
      type FOREIGN (client is not running this program).

      Remote NEWCLI clients running this program always send bytes, and
      so drainf() always changes their type to LOSERV.  

      But if a remote client never sends any bytes, drainf() will not 
      be entered again, and the client will remain type NEWCLI.  Such
      "FOREIGN" clients are subject to disconnection in the time span
      of conn_alarm().
*/
/* When this program is at the client end of a connection: */
#define LOCLI   0 /* from this prog here to this prog there */
#define NATIVE  1 /* from this prog here to foreign prog there */

/* When this program is at the server end of a connection: */
#define LOSERV  2 /* to this prog here from this prog there  */
#define FOREIGN 3 /* to this prog here from foreign prog there */

#define NEWCLI -1 /* new just connected from there to this prog here */
int clindx; /* max index in FD_FSETSIZE lists defined below: */

int client[FD_SETSIZE]; /* client descriptors */
int clport[FD_SETSIZE]; /* client ports */
double cliptr[FD_SETSIZE]; /* ptr to run when receive in drainf() */
double clsptr[FD_SETSIZE]; /* ptr to run in clientclose() */
time_t clitim[FD_SETSIZE]; /* times of connection */
time_t clitimoff[FD_SETSIZE]; /* times of disconnection */
char *clientIP[FD_SETSIZE]; /* IP addresses */
char *clientLOGIN[FD_SETSIZE]; /* login+host ID */
int contyp[FD_SETSIZE]; /* connection types */
int SELECT[FD_SETSIZE]; /* equals 1 if select is reading input */
int SELECT_CLR[FD_SETSIZE]; /* used by setselect() */

int sockCLI[FD_SETSIZE]; /* array of client numbers on sockets */
/* The index for accessing array sockCLI is socket number.
      Example: 
         cn=*(sockCLI+sockfd) returns cn=1, the second client index
         (index for first client is zero).  

         Client index cn=1 is then used to access arrays like client, 
         cliport, cliptr, ..., SELECT.
*/
int Accept(int fd, struct sockaddr *sa, socklen_t *salenptr);
int cog(); /* COG (f --- ) */
int CONNECT(); /* CONNECT (qIPaddr nPort ptrRun --- nSocket) */
int connect_timeo(int sockfd, const struct sockaddr *saptr, \
   socklen_t salen, int nsec);
int connto(); /* connto (sec --- ) */
int connto_val(); /* CONNTO ( --- sec) */
int _client_open(int sockfd);
int client_open(); /* client_open (nSocket --- f) */
int clientindex(); /* clientindex (nSocket --- k) */
int clientIPs(); /* clientIPs ( --- hT) */
int clientLOGIN_set(); /* clientLOGIN_set (hT k --- ) */
int clientLOGINs(); /* clientLOGINs ( --- hT) */
int clients(); /* clients ( --- ) */
int clientsockets(); /* clientsockets ( --- hA) */
int clienttimesoff(); /* clienttimesoff ( --- hA) */
int clienttimeson(); /* clienttimeson ( --- hA) */
int drain(int sockfd);
int drainf(int sockfd, int type_in, double ptrRun);
int export8n(); /* export8n (hA --- hT) */
int _IPhost(); /* _IPhost (qHost --- hT) */
int import8n(); /* import8n (hT --- hA) */
unsigned int ip4_scan(char *s, char ip[4]);
int netendian(); /* netendian (endian --- ) */
int netrate(); /* netrate (bytes/sec --- ) */
int netrate_val(); /* NETRATE ( --- bytes/sec) */
int netvolread(); /* netvolread (nSocket --- hT) */
int netvolwrite(); /* netvolwrite (hT nSocket --- ) */
int ptrCls(); /* ptrCls (nSocket --- ptr) */
int ptrCls_upd(); /* ptrCls_upd (ptr nSocket --- ) */
int ptrRun(); /* ptrRun (nSocket --- ptr) */
int ptrRun_upd(); /* ptrRun_upd (ptr nSocket --- ) */
int read_f(); /* READ_F (n --- ) */
ssize_t read4n(int fd, unsigned int *n);
int readable_timeo(int fd, time_t sec, time_t usec, int *bytes);
ssize_t readn(int fd, void *vptr, size_t maxlen);
ssize_t readn1(int fd, void *vptr, size_t len);
int remotefd(); /* remotefd ( --- nSocket) */
int remoteget(); /* remoteget (nSocket --- hT)
                    stack on remote: (hT --- ) */
int remoteput(); /* remoteput (hT nSocket --- )
                    stack on remote: ( --- hT) */
int remoteputf(); /* remoteputf (hT nSocket --- ) */
int remoteputf0(); /* remoteputf0 (hT nSocket --- ) */
int remoteputfb(); /* remoteputfb (hT nSocket nSec --- ) */
int remoteputmat(); /* remoteputmat (hA nSocket --- );
                       stack on remote: ( --- hA) */
int remoterun(); /* remoterun (hT nSocket --- ) */
int remoterun2(); /* remoterun2 (hT1 hT2 nSocket --- ) */
int remoterun_DELAY(); /* remoterun_DELAY ( --- d) */
int remoterun_delay(); /* remoterun_delay (sec --- ) */
unsigned int scan_ulong(register char *s, register unsigned long *u);
int sclose(); /* sclose (nSocket --- ) */
int sflush(); /* sflush1 (nSocket --- hT) */
char *sock_ntop(const struct sockaddr *sa, socklen_t salen);
int test_socket_openw(int sock);
int test_socket_readable(); /* socket_readable (nSocket --- nBytes) */
int test_socket_writable(); /* socket_writable (nSocket --- f) */
int writable_timeo(int fd, time_t sec, time_t usec);
ssize_t write4n(int fd, unsigned int h);
ssize_t writen(int fd, const void *vptr, size_t n);
ssize_t writen1(int fd, const void *vptr, size_t n);

/* end net.h headers */
