{  File tops_http.v
   February 2005

   Copyright (C) 2005  Dale R. Williamson

   Words for daemon server tops_http.

   This file contains words and phrases sourced by tops_http at start
   up.

   Running the program as a daemon, script tops_http listens on port
   80 for an HTTP request, forwards it to Apache running with these
   directives in /etc/apache/httpd.conf:
      BindAddress 127.0.0.1
      Port 9880
   and then sends the HTTP response to the requestor.
}
\-----------------------------------------------------------------------

   CATMSG push no catmsg

\-----------------------------------------------------------------------

\  Words.

   inline: HOSTcheck (qR nSocket --- qR) \ check HTTP response to host
{     Adds client host IP to usrpath/ACCESS.

      Checks HTTP response to client host for HTTP client error 4xx.

      If the server response to host is an acceptable client error 
      message, the IP address in usrpath/ACCESS will have * appended
      to it, indicating a "good" IP address.

      With * appended, good IP addresses will not be matched later when
      APP_CLIENT_ALLOW checks the list for connecting IP addresses to
      not to allow.

      See Appendix for the 4xx and 5xx client error messages, which are
      taken to be unacceptable errors.
}
      (nSocket) this clientindex -1 >
      IF (qR nSocket)
         clientIPs swap (S) clientindex quote strchop (qIP)

         (qR qIP) that (qR) uppercase "<TITLE>" "</TITLE>" between 
         noblanklines any?
         IF (qW) numerate any?
            IF ontop "N" book
               N 400 499 within
               N 500 599 within or
               IF " " ELSE "*" THEN
            ELSE "*"
            THEN
         ELSE "*"
         THEN (qIP qTAG) +
         (qR qIP) spaced date +

         "APP_CLIENT_ALLOW" "FILE" yank "FILE" book
         FILE file? IF FILE asciiload ELSE "" THEN (hT)

         (qR qIP hT) swap pile (hT1)
         (qR hT1) chop noblanklines neat (hT1) FILE save (qR)

      ELSE (qR nSocket) drop
      THEN (qR)

      (qR) "Port 9880" "Port 80" strp \ replace 9880 with 80
   end
\  Bank the ptr to HOSTcheck into HTTPput for its RESPONSEcheck:
   "HOSTcheck" ptr "HTTPput" "RESPONSEcheck" bank

   inline: REQUESTcheck (qR nSocket --- qR1) \ check HTTP request
\     If invalid request, replace R with R1 that will cause access
\     to be denied.
      [ "CONNECT " "BAD_REQUEST" book, 256 "CHECK" book 

        "index.html SUMMARYR.TXT default.html" words mpath nose (hT)
        "REQUESTS" book
      ]
      drop "R" book


    \ Look at CHECK bytes (1st line is only about 16 bytes).
    \ Word crowd removes commas and puts one space between strings.
      R 1st over chars CHECK min items catch crowd spaced "Rcheck" book 

      "REQUESTcheck " Rcheck 1st over chars 10 min items catch + ERRset

      0
      Rcheck "GET http://"      grepr rows any or
      Rcheck "GET /default.ida" grepr rows any or
      Rcheck "CONNECT"          grepr rows any or
      Rcheck "SEARCH / "        grepr rows any or
      Rcheck "POST"             grepr rows any or
      Rcheck "HEAD"             grepr rows any or
      Rcheck "Authorization"    grepr rows any or
      Rcheck "Negotiate"        grepr rows any or

      IF BAD_REQUEST R +
      ELSE 
      {  Touch the file that is requested or Apache will be very slow
         in responding (somehow due to requesting from local 127.1.1.0 
         and Apache detecting that the file has not changed):
      }  Rcheck 2nd word 
         IF -path (hRfile) any?
            IF REQUESTS (hR) dup rot (hR hRfile) grepr any?
               IF (hR hRows) reach "touch " swap + shell
               ELSE (hR) drop
               THEN
            THEN
         THEN

         Rcheck "GET /status.html " grepr rows any
         IF status (hHTML) mpath "status.html" + save
{
         ELSE Rcheck "GET / " grepr rows any
            IF R "GET /" "GET /default.html" strp "R" book 
            ELSE Rcheck "GET /robots.txt " grepr rows any
               IF R "GET /robots.txt" "GET /default.html" strp "R" book 
               THEN
            THEN
}
         THEN
         R 
      THEN (qR1)

      ERR
   end
\  Bank the ptr to REQUESTcheck into HTTPput for its REQUESTcheck:
   "REQUESTcheck" ptr "HTTPput" "REQUESTcheck" bank

   inline: status ( --- hHTML) \ status report from host
\     This is requested by a machine monitoring the status of a host,
\     as a basis for setting ALARMs.
      [ "HOME" env "WORK.LOG"    catpath "W" book
        "HOME" env "COLLECT.LOG" catpath "C" book

      {" (qFname --- hT)
        "fname" book fname -path 12 blpad spaced
        fname filetime ctime + " AGE: " + 
        time fname filetime - intstr + 
      "} "STATUS" macro

      ] 
      host " status on " + date + " TIME: " + time intstr +
      W STATUS pile
      C STATUS pile
      wrapHTML
   end

   inline: WSERVER (qT nSocket --- qR) \ server on local machine
      "S" book textget asciify chop noblanklines "T" book

      " WSERVER: on " host + " received from socket " +
      S intstr + ":" + . nl
      T 3 indent . nl

    \ Send back a response:
      "402 Payment Required" wrapHTML
   end

\-----------------------------------------------------------------------

   pull catmsg private halt

\-----------------------------------------------------------------------

; Appendix

Here are 4xx and 5xx responses from HTTP RFC 2616:

  See: http://www.ietf.org/rfc/rfc2616.txt

   10.4  Client Error 4xx ............................................65
   10.4.1    400 Bad Request .........................................65
   10.4.2    401 Unauthorized ........................................66
   10.4.3    402 Payment Required ....................................66
   10.4.4    403 Forbidden ...........................................66
   10.4.5    404 Not Found ...........................................66
   10.4.6    405 Method Not Allowed ..................................66
   10.4.7    406 Not Acceptable ......................................67
   10.4.8    407 Proxy Authentication Required .......................67
   10.4.9    408 Request Timeout .....................................67
   10.4.10   409 Conflict ............................................67
   10.4.11   410 Gone ................................................68
   10.4.12   411 Length Required .....................................68
   10.4.13   412 Precondition Failed .................................68
   10.4.14   413 Request Entity Too Large ............................69
   10.4.15   414 Request-URI Too Long ................................69
   10.4.16   415 Unsupported Media Type ..............................69
   10.4.17   416 Requested Range Not Satisfiable .....................69
   10.4.18   417 Expectation Failed ..................................70
   10.5  Server Error 5xx ............................................70
   10.5.1   500 Internal Server Error ................................70
   10.5.2   501 Not Implemented ......................................70
   10.5.3   502 Bad Gateway ..........................................70
   10.5.4   503 Service Unavailable ..................................70
   10.5.5   504 Gateway Timeout ......................................71
   10.5.6   505 HTTP Version Not Supported ...........................71

This shows that an Apache server response contains Port 9880.  It is
part of the response to a "404 Not Found" client error:

  46  3C 41 44 44 52 45 53 53 3E 41 70 61 63 68 65 2F  <ADDRESS>Apache/
  48  31 2E 33 2E 32 36 20 53 65 72 76 65 72 20 61 74  1.3.26 Server at
  50  20 74 6F 70 73 64 6F 67 2E 63 6F 6D 20 50 6F 72   topsdog.com Por
  52  74 20 39 38 38 30 3C 2F 41 44 44 52 45 53 53 3E  t 9880</ADDRESS>
  54  0A 3C 2F 42 4F 44 59 3E 3C 2F 48 54 4D 4C 3E 0A  .</BODY></HTML>.

