#include <stdio.h>
#include <stdlib.h>
#include <time.h>      /* gettimeofday, timeval, CLOCKS_PER_SEC, clock_t, clock() */
/*
 * Albert Danial Sept 4 2003
 */

/*
int elmstfMRT_(double *e0, double *g0, double *t0, int *pl0, 
              double *alpha, double *beta, double *area, 
              double *xb1, double *xb2, double *xb3, 
              double *yb1, double *yb2, double *yb3, double *ekb, double *ek9);
int elmstfDKT_(double *e0, double *g0, double *t0, double *zip0, double *area, 
              double *xb1, double *xb2, double *xb3, 
              double *yb1, double *yb2, double *yb3, double *ekb, double *ek9 );
*/
void  dump_matrix(char *mat_name, int nRows, int nCols, double *M);
float elapsed(struct timeval start, struct timeval end);

main(){

      double   e0, g0, t0, xb1, xb2, xb3, yb1, yb2, yb3,
              alpha, beta, area, zip0;
      int     pl0, i, j, nElem;
      double  ekb[18*18], ek9[9*9];
      float   delta_time;
      struct timeval start, end;

      pl0  =  1;

      if (0) {
          e0   =  10000000.0;
          g0   =  4000000.0;
          t0   =  1.0;
          alpha=  1.50;
          beta =  0.5;
          area =  0.00017119963;
          xb1  =  0.221399993;
          xb2  =  0.200000003;
          xb3  =  0.200000003;
          yb1  = -0.792400002;
          yb2  = -0.77640003;
          yb3  = -0.792400002;
          zip0 =  1.0;
          area =  0.00017119963;
      } else if (1) {
          e0   =  10000000.0;
          g0   =  4000000.0;
          t0   =  1.0;
          alpha=  1.50;
          beta =  0.5;
          area =  0.00017119963;
          xb1  =  2.0;
          xb2  =  3.23669386;
          xb3  =  9.42016315;
          yb1  =  2.0;
          yb2  =  0.787321925;
          yb3  =  2.97014236;
          zip0 =  1.0;
          area =  5.09901953;
      } else {
          exit(1);
      }

      for (i = 0; i < 18*18; i++)
          ekb[i] = 0.0;

      elmstfmrt_(&e0, &g0, &t0, &pl0, &alpha, &beta, &area,
                 &xb1, &xb2, &xb3, &yb1, &yb2, &yb3, ekb, ek9);

      printf("after elmstfMRT\n");
      dump_matrix("ek9",  9,  9, ek9);
      dump_matrix("ekb", 18, 18, ekb);

      elmstfdkt_(&e0, &g0, &t0, &zip0, &area, 
                 &xb1, &xb2, &xb3, &yb1, &yb2, &yb3, ekb, ek9 );

      printf("after elmstfDKT\n");
      dump_matrix("ek9",  9,  9, ek9);
      dump_matrix("ekb", 18, 18, ekb);

      /* time element matrix generation */
      gettimeofday(&start, 0);
      nElem = 1000;
      for (j = 0; j < nElem; j++) {
          xb1 +=  0.2;
          xb2 +=  0.3;
          xb3 +=  0.1;
          for (i = 0; i < 18*18; i++)
              ekb[i] = 0.0;
          elmstfmrt_(&e0, &g0, &t0, &pl0, &alpha, &beta, &area,
                     &xb1, &xb2, &xb3, &yb1, &yb2, &yb3, ekb, ek9);
          elmstfdkt_(&e0, &g0, &t0, &zip0, &area, 
                     &xb1, &xb2, &xb3, &yb1, &yb2, &yb3, ekb, ek9 );
      }
      gettimeofday(&end,   0);
      delta_time = elapsed(start, end);
      printf("elapsed = %10.3f  (%.3f elem/sec)\n",  delta_time, nElem/delta_time);
}
void dump_matrix(char *mat_name, int nRows, int nCols, double *M) /* {{{1 */
{
      int i, j;
      printf("dump_matrix for %s\n", mat_name);
      for (i = 0; i < nCols; i++) {
          for (j = 0; j < nRows; j++) {
              printf("%10d %10d % 15.8e\n", j+1, i+1, M[j + i*nRows]);
          }
      }
}
/* 1}}} */
float elapsed(struct timeval start, struct timeval end) {  /* {{{1 */
    return  (float) (end.tv_sec - start.tv_sec) +
           ((float) (end.tv_usec - start.tv_usec)/1000000);
}
/* 1}}} */
