/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* essl.h  March 2001

   Copyright (c) 2001   D. R. Williamson

   Reference:
      Engineering and Scientific Subroutine Library, Version 2, 
      Release 2, Second Edition (January 1994), IBM Corporation.

*/

#ifdef FORT_UDSC
void   daxpy_();
void   dcopy_();
double ddot_();
void   dgeev_();
void   dgemm_();
void   dscal_();
void   dsygv_();
void   zgemm_();

#define DAXPY daxpy_
#define DCOPY dcopy_
#define DDOT  ddot_
#define DGEEV dgeev_
#define DGEMM dgemm_
#define DSCAL dscal_
#define DSYGV dsygv_
#define ZGEMM zgemm_

#else
void   daxpy();
void   dcopy();
double ddot();
void   dgeev();
void   dgemm();
void   dscal();
void   dsygv();
void   zgemm();

#define DAXPY daxpy
#define DCOPY dcopy
#define DDOT  ddot
#define DGEEV dgeev
#define DGEMM dgemm
#define DSCAL dscal
#define DSYGV dsygv
#define ZGEMM zgemm
#endif

#if defined(ESSL)
   #include <essl.h>
#endif

int ceigSSL(); /* ceigSSL (hC f --- hLr hLi hAr hAi) */
int ceigNEW(); /* ceigNEW (hC f --- hLr hLi hAr hAi) */
int cmpySSL(); /* cmpySSL (hAr hAi hBr hBi --- hCr hCi) \ C=A*B */
int diagpostSSL(); /* diagpostSSL (hA hV --- hB) */
int dotprodSSL(); /* *dotSSL (hA hB --- hV) */
int movecSSL(); /* movecSSL (hV hA c --- ) */
int mpySSL(); /* mpySSL (hA hB --- hC) \ C=A*B */
int plusSSL(); /* plusSSL (hA hB --- hC) \ C=A+B */
int reigSSL(); /* reigSSL (hA hB --- hZ hw) */
int solveSSL(); /* solveSSL (hb hA --- hx) */
int symSSL(); /* symSSL (hb hA --- hx) */
int starfSSL(); /* *fSSL (hA f --- hB) \ B(i,j)=A(i,j)*f */
int trilowSSL(); /* trilowSSL (hA --- hL) */

/* end essl.h headers */
