/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* ordering.h  May 2001

   Albert Danial

*/

#ifdef BLAS
#ifdef FORT_UDSC
void dcopy_();
#else
void dcopy();
#endif
#endif

int sort_seq();  /* sort_seq (hA --- hS ) */
int reorder();   /* reorder  (hS P hA --- hS P ) */
int ascending(); /* ascending (hA --- f ) */
int new_name();  /* new_name ( A qName --- B ) */

typedef struct {
    double value;
    int    position; } Sort_D_Record ;

typedef struct {
    char   string[9];
    int    position; } Sort_A_Record ;

int  comp_D_Record(const void *a, const void *b);
int  comp_A_Record(const void *a, const void *b);
void update_ordering(int N, int new_i, int old_i, int nPerm, Sort_D_Record *Perm);
