\{{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{  File say.v  December 2000

   Copyright (c) 2000   D. R. Williamson

   Words to make the machine talk.
}
\-----------------------------------------------------------------------

   "record" missing IF "snd.v" source THEN
   "record" missing \ still missing?
   IF " say.v: require sound words" . nl halt THEN

   "ranint" missing IF "math.v" source THEN

\-----------------------------------------------------------------------

\  Saying things.

   inline: he_say (hT --- qS) \ saying words in T according to a voice
{     Words in T are re-spelled for Voice that is in word saying.

      Reenters (up to max_entries times) until no more matches.
      Example.  With these entries for %Gutter:

         J_ "april" (J_ is market symbol for april)
         april "ayyyy-p-riiill"

      entering with "J_" will find "april," and reentering with "april"
      will find "ayyyy-p-riiill."

      Trailing punctuation will be retained, such as comma, dot and
      ellipsis, but strings in rows of T are filtered to contain only
      the following characters (uppercase is converted to lowercase):
}     [ "_+-'abcdefghijklmnopqrstuvwxyz1234567890" into CHARS 
        "" into MATCH, no into entries, 10 into max_entries
      ]
      depth nit push
      strings dup push rows 1st
      DO peek I quote
         strchop lowercase these CHARS chkeep

         saying \ words the way Voice says

         swap CHARS chblank strchop cat
      LOOP pull drop
      depth pull less pilen vol2str

      this MATCH strmatch 0<> entries max_entries < and

      IF one entries bump

         this "MATCH" book he_say \ reenter until no change in S

      ELSE "" "MATCH" book no "entries" book

      THEN
   end

   inline: saying (qS --- qS1) \ S1 for Voice saying string S
{     Interface to hash of Voice.

      Hash of Voice must have been banked here, using a phrase like:

         %Gutter 'saying' 'Voice' bank

      where, for example, %Gutter is a hash of words and how to say
      them (see Personalities in this file).

      When there are multiple choices for S1, one is randomly picked
      from the possibilities.

      When there is no choice, S is simply passed on in S1.

}     [ no is Voice ]
      Voice that hash_lookup drop any?
      IF one those rows one one ranint ontop ndx quote lop THEN
   end

   inline: sayit (qS --- ) \ say the string
      no STR stkok not IF "sayit" stknot return THEN
      he_say record play ;
      
   inline: rectime ( --- hT) \ record the current time to volume T
      systime$ time# record
   end

\-----------------------------------------------------------------------

{  Saying numbers.

   These ways of quoting numbers have been honed from listening to
   hourly voice updates in a real application over many months.

   The listener is assumed to know what type of number is being quoted,
   and for speed, extraneous words are avoided.  For instance, saying
   "point" every time a number is quoted can add 25 or 30 seconds to a
   phone message of 30 quotes.

   Yet not saying "point" can sometimes make a quote unclear.  While
   101.40 said as "one-hundred-one forty" is clear, saying 100.40 in
   the same way, "one-hundred forty," may be taken to mean 140.  

   Saying "point" in this case makes the quote unambiguous: "one-hun-
   dred point forty."
}
   inline: and10# (qN1N2 --- qN1_and_N2) \ quote number with and
\     3591 is "three-hundred-fifty-nine and one"
      number 
      IF this 9 > 
         IF ten /mod int$ hundred1# " and " rot dup 0>
            IF say# ELSE 2drop "even " "" THEN cat cat
         ELSE int$ quote#
         THEN
      ELSE undefined#
      THEN
   end

   inline: and100# (qN1N2 --- qN1_and_N2) \ quote number with and
\     50075 is "five hundred and seventy-five"
      number 
      IF this 99 >
         IF 100 /mod int$ hundred1# " and " rot dup 0>
            IF say# ELSE 2drop "even " "" THEN cat cat
         ELSE int$ quote#
         THEN
      ELSE undefined#
      THEN
   end

   inline: each# (n --- qS) \ say each digit of number n
      zero NUM stkok not
      IF "each#" stknot return THEN

      ohzero drop \ initialize

      (n) int$ (qS) strchop dup push chars 1st
      DO peek I character LOOP
      pull chars pilen
      dup push rows 1st
      DO peek I quote (qS) number drop dup 0=
         IF drop OHZERO ELSE say# THEN " ... ..." cat (qS)
      LOOP pull rows pilen vol2str sp
   end

   inline: hundred# (qN --- qN1) \ quote number Y-hundred XX
      number 
      IF dup 0< push abs 
         100 /mod this 0>
         IF say# "hundred " cat that 0<>
            IF swap say# cat 
            ELSE lop 
            THEN
         ELSE drop say#
         THEN pull IF "- " swap cat THEN
      ELSE undefined#
      THEN
   end

   inline: hundred1# (qN --- qN1) \ quote number YY XX
{     2500 is "twenty-five hundred"
      2566 is "twenty-five sixty-six"
      2502 is "twenty-five oh-two or twenty-five zero-two"
}     number 
      IF dup 0< push abs
         100 /mod this 0>
         IF say# that 0<>
            IF swap this 9 > 
               IF say# ELSE ohzero swap say# cat THEN
            ELSE lop "hundred " 
            THEN cat
         ELSE drop say#
         THEN pull IF "- " swap cat THEN
      ELSE undefined#
      THEN
   end

   inline: IP# (qIP --- qS) \ say an IP address
{     Example: for IPloop (127.0.0.1) IP#, Gutter says:
         wo-o-o-nn   ... toooo   ... severn   ... point  
         ... owwwwwwe  ... point  ... owwwwwwe  ... point  
         ... wo-o-o-nn   ... 
}
      [ "point " "POINT" book ]
      ohzero drop \ initialize
      (qS) strchop dup push chars 1st
      DO peek I character LOOP pull chars pilen
      dup push rows 1st
      DO peek I quote strchop dup (qS) "." = 
         IF drop POINT
            ohzero drop \ initialize
         ELSE (qS) number drop dup 0=
            IF drop OHZERO ELSE say# THEN 
         THEN (qS) " ... " cat
      LOOP pull rows pilen vol2str sp
   end

   inline: OHZERO ( --- qZero) \ the most recent ohzero
      "ohzero" "OHZERO" yank ;

   inline: ohzero (  --- qZero) \ zero or oh
      [ " zero " "OHZERO" book ]
      flip IF " zero " ELSE " oh " THEN he_say this "OHZERO" book ;

   inline: pair10# (qN1N2 --- qN1_N2) \ quote number as pair 10 /mod
{     2566 is "two-hundred-fifty-six and six"
      1150 is "one hundred fifteen even"
      115 is "eleven and five"
}     number 
      IF dup 0< push abs this 9 > 
         IF ten /mod dup 999 >
            IF int$ thousand# 
            ELSE dup 99 >
               IF int$ hundred#
               ELSE say# 
               THEN
            THEN "and " rot dup 0=
            IF 2drop dup "even" grepr any? 
               IF drop ""   \ already saying "even"
               ELSE "even " \ say "even" 
               THEN "" 
            ELSE say# 
            THEN cat cat
         ELSE int$ quote#
         THEN pull IF "- " swap cat THEN
      ELSE undefined#
      THEN
   end

   inline: pair100# (qN1N2 --- qN1_N2) \ quote number as pair 100 /mod
{     9856 is "ninety-eight fifty-six"
      3032 is "thirty thirty-two"
     10040 is "one hundred point forty"
     20308 is "two-oh-three oh-eight" or "two-zero-three zero-eight"
}     no "say_zero" book 
      number 
      IF dup 0< push abs this 99 > 
         IF 100 /mod this 10 < 
            IF 100 * int$ hundred1#
            ELSE this 0> 
               IF dup int$ hundred1# 
                  swap 100 mod 0= 
                  IF that 0<> 
                     IF " point " cat THEN \ "200 point 40"
                  THEN
                  yes "say_zero" book
               ELSE drop ""
               THEN
            THEN that 0<>

            IF swap this 9 > 
               IF say# 
               ELSE say_zero 
                  IF OHZERO ELSE "" THEN swap say# cat
               THEN

            ELSE lop "even " 
            THEN cat
         ELSE int$ quote#
         THEN pull IF "- " swap cat THEN
      ELSE undefined#
      THEN
   end

   inline: pair1000# (qN1N2 --- qN1_N2) \ quote number as pair 1000 /mod
\     5065 is "five zero six five"
      number
      IF this 999 >
         IF 1000 /mod
            say# swap 100 /mod say# swap dup 0>
            IF 10 /mod say# swap say#
            ELSE drop "zero zero " "" \ do not put "even" here
            THEN
            cat cat cat
         ELSE int$ quote#
         THEN
      ELSE undefined#
      THEN
   end

   inline: quote# (qN --- qN1) \ quote a number using default
\     9856 is "nine-thousand eight-hundred fifty-six"
\     3032 is "three-thousand and thirty-two"
      number IF say# ELSE undefined# THEN
   end

   inline: say# (n --- qS) \ ways of saying numbers
      int$ he_say spaced ;

   inline: say0# (n --- qS) \ if ending 0, say zero
\     In trip121#, this word helps trip121# to play 5802 as 
\     "five eight zero two" instead of "five eighty two"
      dup 10 /mod that 0=
      IF say# lop ohzero cat lop
      ELSE 2drop dup 10 < 
         IF ohzero ELSE "" THEN swap say# cat
      THEN
   end

   inline: thousand# (qN --- qN1) \ quote number Y-thousand XX
\     3032 is "three-thousand and thirty-two"
      number
      IF 1000 /mod say# "thousand " cat swap dup 100 >
         IF int$ hundred# cat
         ELSE dup 0>
            IF " and " swap say# cat cat
            ELSE drop " even " cat
            THEN
         THEN
      ELSE undefined#
      THEN
   end

   inline: time# (qH:M:S --- qHM) \ say time hour and minute
\     Saying 11:05 as "eleven-oh-five o'clock."
      oclock 100 / integer 100 /mod (M H)
      int$ quote# swap this 0<>
      IF this 10 < 
         IF int$ quote# " o " swap cat 
         ELSE int$ quote#
         THEN
      ELSE drop "hundred"
      THEN " o clock" cat cat
   end

   inline: trip121# (qN1N2N3 --- qN1_N2_N3) \ three quotes: X YY Z
{     2567 is "two fifty-six seven"
      With help from say0#:
         6000 is "6 zero zero ... even"
         6091 is "6 zero nine and one"
}     number
      IF ten /mod 100 /mod

         say# swap dup 0=
         IF drop " zero zero ... "
         ELSE say0#
         THEN

         cat swap dup 0<>
         IF swap "and " cat swap say# cat
         ELSE drop "even " cat
         THEN

      ELSE undefined#
      THEN
   end

   inline: trip211# (qN1N2N3 --- qN1_N2_N3) \ three quotes: XX Y Z
\     2567 is "twenty-five six seven"
      number
      IF ten /mod ten /mod
         say# swap say# cat swap say# cat
      ELSE undefined#
      THEN
   end

   inline: undefined# ( --- qS) \ say that number is undefined
      "undefined" he_say ;

\-----------------------------------------------------------------------

\   Personalities.

\   Gutter.

   {" Keys and patterns for Gutter's words.

      a "ay-yy"
      acquire "aaah quire"
      again "ahhhgayne"
      again "aah gain"
      ago "uhgo"
      al "aaalll"
      all "alll"
      and "aaaand"
      and "aand"
      are "aerrrh"
      are "ar-er"
      at "aaat"
      between "beeee tweeeen"
      british "bree-tish"
      busy "bizzy"
      car "ca-aa-er"
      cocoa "cowwwhhcowww"
      coffee "coff-fee"
      commit "co mmitt"
      copper "cau perrr"
      copper "coh hper"
      cotton "kuttennn-n"
      could "coo-oo-ood"
      dale "day-yy-yy-ll-ll-ll"
      detect "deee tect"
      difference "diff-rence"
      different "diff rent"
      even "eeeeeeven"
      even "eeeeeeeyvaaaaan"
      federal "feduh-roll"
      friend "fr-enn-d"
      gas "gaaaas"
      gasoline "gaasssso-leeeen"
      gold "goal-old"
      good "goo-d"
      gutter "goo-ter"
      heating "heeeeting"
      hello "hell-o-o-o"
      hello "haa-low"
      hello "haa-loo-oo"
      here "heeer"
      huh "haaaaah"
      i'm "ay-yy-yym"
      i'm "ay-yym"
      instance "instonce"
      introduce "inn-tro-o-duce"
      is "ees"
      is "ee-ee-s"
      library "ly brar-ee-ee"
      linux "lee-nix"
      long "loungue"
      natural "natchar-al"
      oh "owwwwwwa"
      oh "owwwwwwe"
      oil "oyl"
      oil "oyyl"
      other "udder-rr"
      platinum "plat-ee-nnummmm"
      pound "pow-und"
      my "ma-ay-yy"
      new "noooooooooh"
      silver "seeeel-ver"
      sorry "saahhhhhhhhrryyy"
      talk "tall-ll-lk"
      telephone "tel-ee-phone"
      that "daat"
      the "theee"
      the "the-ee"
      the "dee-ee-ee"
      the "daaa"
      there "theyyy-yerrrrr"
      there "thaaaaerrrr..."
      this "diissss"
      this "dis"
      this "dees"
      to "toooo"
      today "too day"
      treasury "tray-zur-yy"
      say "sayyy"
      said "siiiad"
      segundo "se goo ndo"
      sugar "shoooo-gur"
      sure "shur-rr"
      sure "shurrre" 
      undefined "un dee fined"
      unload "unnl .. load"
      we "wwweeeeee"
      what "what"
      what "whaaat"
      where "where-er" 
      you "yoo-oo-oo"
      zero "0"
      laugh_ "o o o ee ee ee oo oo oo ... "
      laugh_ "oo oo oo ee ee ee o o o ... "

      01 "oh 1"
      02 "oh 2"
      03 "oh 3"
      04 "oh 4"
      05 "oh 5"
      06 "oh 6"
      07 "oh 7"
      08 "oh 8"
      09 "oh 9"
      
      0 "z-ee-ee-ro"
      0 "oh"
      1 "wo-o-o-nn"
      2 "toooo"
      7 "severn"
      9 "nyunnn"
      10 "tennnnnn"
      11 ".. eeeelevaan"
      13 "dirrrt-teeeeeen"
      14 "foor-teeeeeeeeeennnn"
      15 "fif-fteeeeeeeeeennnnnn"
      16 "six-teeeeeeeeeennnnnn"
      17 "severn-teeeeeeeeeennnnnn"
      18 "ayyyte teeeeeeeennnnnnn"
      19 "nyunnntee-ee-ee-n"
      27 "20 7"
      29 "20 9"
      30 "thir-tee"
      37 "30 7"
      39 "30 9"
      40 "foar-tey"
      40 "forteee"
      47 "40 7"
      49 "40 9"
      50 "fif-tyy"
      50 "fifff-teeee"
      55 "50 5"
      57 "50 7"
      59 "50 9"
      60 "siiiix-teyy"
      60 "sixteeee"
      67 "60 7"
      69 "60 9"
      70 "severnn de"
      70 "severn tee"
      77 "70 7"
      79 "70 9"
      87 "80 7"
      89 "80 9"
      90 "nyi-deeee"
      97 "90 7"
      99 "90 9"

      - "minus"
      - "negative"
      - "down"
      - "down"

      + "positive"
      + "plus"
      + "up"
      + "up"

      january "jan uairy"
      february "feb-u-air-ry"
      march "maaa-arrch"
      march "mmm-mar-rr-rr-ch"
      april "ayyyy-p-riiill"
      may "maayyyy"
      june "juoooo-nnnnn"
      july "juligh"
      august "au-gust"
      september "september"
      october "awctober"
      november "nowvember"
      december "december"

   "} (hT) asciify noblanklines this 1st word drop (hKeys) 
   swap (hT) '"' tug '"' chblank (hVals)

   (hKeys hVals) 4000 "%Gutter" dup hash? 
   IF %Gutter hash_close THEN hash_make

   "10500" "GutterHZ" inlinex
   %Gutter 'saying' 'Voice' bank

   inline: greeting ( --- qFile) \ greeting file from Gutter
      [ %Gutter 'saying' 'Voice' bank
        GutterHZ "frecord" "HZ" bank

        "Hello.  This is Gutter.  Here is my report at"
        he_say record (hT) "hello" book

        "frecord" "moHZ" yank into moHZ
        no is hFile

      \ The name of the file returned by this word:
        "_bin" "tmppath" yank runid cat "greet.tmp" cat makes GREET
      ] 
      GREET deleteif

      GutterHZ "frecord" "HZ" bank
      hello rectime cat (hT) one silence (hT) \ sound bytes

\     Make a wave file header at voice modem speed and prepend the
\     header to the sound bytes:
      (hT) these bytes 8 (bits/sample) moHZ wavHeader swap cat (hT)

\     Save a sound file and return its name on the stack:
      (hT) GREET (qFile) forn binary "hFile" file
      (hT) hFile fput \ saving file named qFile

      hFile fclose GREET
   end

\-----------------------------------------------------------------------

   private halt

;  Appendix

References for recording and playing:

1. A program that turns text into a sound file came from:

      http://www-internal.alphanet.ch/archives/local/alphanet/mvm/
         linux-binaries/RSYNTH-PATCHED/
      file: say.ELF-libc5-static.gz 21-Feb-1999 19:31    81k

   File say.ELF-libc5-static.gz is a compiled version of rsynth (whose 
   tar file is rsynth-2.0.tgz in /home/home/rsynth-2.0/).

   When downloaded in Netscape you get 212628 bytes.  Here is the file 
   saved as say.ELF-libc5-static.  It is not a gz file, so ignore the 
   extension.  It executes.

   -rw-rw-r-- 1  dale  dale   212628 Dec  7 17:04 say.ELF-libc5-static

   This is the identical file (212629 bytes) downloaded a couple of 
   years ago and used for the voice of Gutter.  That file was lost, but
   here is its replacement.  Also see notes in file /home/rsynth-2.0/
   READMEdrw.

2. A program that records over microphone and plays through speaker 
   came from:

      http://www.4front-tech.com/snd-util-3.8.tar (327680 bytes)

   Here are some files stored on zip drive that came out:

   [root@gutter] /mnt/zip/sound/oss/sndkit/dsp # ll
   total 694
   drwxrwxr-x   2 root     root         2048 Aug 13  2000 ./
   drwxrwxr-x   3 root     root         2048 Aug 13  2000 ../
   -rwxrwxr-x   1 root     root         2383 Jul 30  1996 help.c*
   -rwxrwxr-x   1 root     root         1636 Aug 13  2000 help.o*
   -rwxrwxr-x   1 root     root          500 Oct  2  1996 makefile*
   -rwxrwxr-x   1 root     root          470 May 21  1996 readme*
   -rwxrwxr-x   1 root     root         6337 Feb 18  1997 recplay.c*
   -rwxrwxr-x   1 root     root         5484 Aug 13  2000 recplay.o*
   -rwxrwxr-x   1 root     root       672000 Aug 13  2000 sample.au*
   -rwxrwxr-x   1 root     root         6348 Aug 13  2000 srec*
   [root@gutter] /mnt/zip/sound/oss/sndkit/dsp # 

   And here are the executables in /usr/local/bin/voice that are being 
   used to record and play sound (microphone to speaker):
     [dale@gutter] /usr/local/bin/voice > ll splay srec
     lrwxrwxrwx 1   19 Aug 13 2000 splay->/usr/local/bin/voice/srec*
     -rwxr-xr-x 1 6348 Aug 13 2000 srec*

\-----------------------------------------------------------------------

   Making words more clear.

   The sounds of numbers 13 and 30 are difficult to distinguish.  In 
   fact, most of the "teens" are unclear: 18 sounds like 80, 19 sounds 
   like 90.

   Word sayit lets short phrases be tested in a few seconds, to create 
   butchered text that makes a word easier to understand.

   Phrases for testing number phrases:
         '3032' pair100# sayit
         '1332' pair100# sayit

   mgetty/say is pretty smart; the default, word quote#, puts "and"
   between "33-thousand" and "thirty-two" in the following:
      '33032' quote# sayit
   Word thousand# does not:
      '33032' thousand# sayit

   Example running word greeting, which inserts the current time:
      [tops@gutter] ready > date . nl greeting 8 9.6 fplay
      Sun Dec 17 11:35:01 PST 2000
       Recording current time: Actual sound rate: 16000
      Speed 14000 Hz (mono)

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  Making a recording in December 2000 to send to Al Danial's voice 
\  mail by playing the speaker output into a regular telephone (no 
\  voice modem working yet--that will only take another two years):

   INTRO
   "saying" missing IF "say.v" source THEN 

   GutterHZ "frecord" "HZ" bank

\  The text-to-speech program, rsynth, is limited in the size of quoted
\  string sent to it, so this demo is broken into pieces that are ap-
\  pended using word cat.

   {"
   Hello Al ... ...  This is ... ... Gutter.  ... ... ... ...
   Our friend ... ... Dale wanted me to telephone you and
   introduce myself.
   ... ... ... ...
   "} he_say record (hT)

   {"
   We actually met once at the El Segundo library when you
   carried me from the car and got my Linux working.
   ... ... ... ...
   That was sure a long time ago.
   ... ... ... ...
   Finally I'm learning to talk.
   ... ... ... ...
   "} he_say record cat (hT)

   {"
   I have to learn numbers first.  ... ...
   For instance so number 13 sounds different from number 30.
   ... ...
   Could you detect the difference?
   ... ... ... ...
   Here are the numbers I'm working on today.
   ... ... ... ...
   "} he_say record cat (hT)

   {"
   0 1 2 3 4 5 6 7 8 9 10 11 12 13 30 13 30  ... ...
   14 40 14 40 14 ... ... 15 50 15 50 ... ... 16 17 18  ... ...
   "} he_say record cat (hT)

   {"
   19 ...  90 ... 19 90 ... ... 20 21 and 22 ... ...
   I'm also learning to quote the time of day like
   "} he_say record cat (hT)

   "12:06:00" time# " and " cat "8:32:00" time# cat record (hT1)
   (hT hT1) cat (hT)
   
   {"
   ... ... ... ...
   Between this and all my other work, I'm getting very busy.
   ... ... ... ...
   Talk to you later Al.
   ... ... 
   Good bye.
   "} he_say record cat (hT)

\  Prepending a .wav header:
   these bytes 8 "frecord" "moHZ" yank wavHeader (hH) swap cat (hT)

\  Opening a file:
   "/tmp/gutter_intro.wav" this deleteif
   new binary "wav" this closeif open

\  Writing the file:
   (hT) wav fput wav close

   private halt

\-----------------------------------------------------------------------

   Gutter and friends, 2003

\  Run this region with: "say.v" "Gutter and friends, 2003" msource

   "fft" exists? not IF " Require FFT words" . nl halt THEN

\  Using Kel and Irene, 16 bit, 16 kHz voices made from Festival web
\  site, user-made demos:

\     http://www-2.cs.cmu.edu/~awb/festival_demos/userin.html

\  Requires these sound files: 
      "/usr/local/sound/" is path

\     Files made at /festival_demos:
      path "kel1.wav"   catpath "Kel1"   book
      path "kel2.wav"   catpath "Kel2"   book
      path "kel3.wav"   catpath "Kel3"   book
      path "irene1.wav" catpath "Irene1" book
      path "irene2.wav" catpath "Irene2" book

\     File made above:
      path "gutter_intro.wav" catpath dup file? 
      IF (qFile) "Gutter" book
      ELSE drop 
         "/tmp" "gutter_intro.wav" catpath dup file?  
         IF (qFile) "Gutter" book
         ELSE syspath "say.v" cat "INTRO" msource \ Gutter's intro
           "/tmp" "gutter_intro.wav" catpath dup file? not
           IF "gutter_intro.wav not found" . nl halt THEN
         THEN
      THEN

   "resample" missing IF "signal.v" source THEN
   "wavData" missing IF "snd.v" source THEN
   "sayit" missing IF "say.v" source THEN

\  Kel starts talking:
      Kel1 wavData drop 1st those bytes .58 * even items catch

\  Irene butts in:
      Irene1 wavData drop 1st those bytes .7 * even items catch 
      cat (hT)

\  Kel starts again and introduces old Gutter:
      Kel2 wavData drop cat (hT)

\  Do some data processing to reduce these 16 bits/sample, 16 kHz
\  sound bytes into 8 bits/sample, 9.6 kHz for the voice modem.

\     Resample at 9600 Hz:
         (hT) LITTLE_ENDIAN import2 (hA)
         16000 9600 resample (hA)

\     Scale resampled 16 bit data to 8 bits per sample:
         list: -32768 32767 ; \ signed 2-byte ints
         list: 0      255   ; \ into unsigned 1-byte ints
         park (hXY) \ table for word lerp
         (hA hXY) swap lerp integer (hA) export1 (hT)

\  Gutter talks (his file was created above by: "say.v" "INTRO" msource
\  and is already 8 bits at 9600 Hz):
      Gutter wavData drop cat (hT)

\  Adding little space after Gutter finishes (using 127; 0 causes a
\  click):
      127 (byte) export1 8000 cats cat (hT1) \ 9600 bytes = one second

\  Kel says good-bye:
      Kel3 wavData drop (hT)

\  Irene says good-bye:
      Irene2 wavData drop cat (hT)

\  More data processing to reduce these 16 bits/sample, 16 kHz sound
\  bytes into 8 bits/sample, 9.6 kHz for the voice modem.

\     Resample at 9600 Hz:
         (hT) LITTLE_ENDIAN import2 (hA)
         16000 9600 resample (hA)

\     Scale resampled 16 bit data to 8 bits per sample:
         list: -32768 32767 ; \ signed 2-byte ints
         list: 0      255   ; \ into unsigned 1-byte ints
         park (hXY) \ table for word lerp
         (hA hXY) swap lerp integer (hA) export1 (hT2)

\  Put the pieces together:
      (hT1 hT2) cat (hT)

\  Play the bytes on the stack:
      (hT) dup play

\  Done.  Write a .wav file:
\     Prepending a .wav header:
         these bytes 8 9600 wavHeader (hH)
         (hT hH) swap cat (hT)

\     Opening a file:
         "/tmp/gutter+friends.wav" this deleteif dup push
         new binary "wav" this closeif open

\     Writing the file:
         (hT) wav fput wav close
         " Gutter and friends written: " nl . pull . nl

\  To play the file:
\     "/tmp/gutter+friends.wav" wavData drop 8 9600 play1

   private halt

\  To play the file over the phone:
      "PHONE_PLAY" missing IF "vmo.v" source THEN
      "/tmp/gutter+friends.wav" wav>rmd Num PHONE_PLAY

   private halt

\  Making an rmd file for slow machine gutter:
      "/tmp/gutter+friends.wav" wav>rmd (qS)
      "mv " swap cat spaced "/tmp/gutter+friends.rmd" 
      cat shell

   private halt

\-----------------------------------------------------------------------

   Irene and the cat

\  To run this region: "say.v" "Irene and the cat" msource

{  Converting a 16 bits/sample, 16 kHz sound file into an 8 bits/sample,
   9.6 kHz file for the voice modem.  

   Irene's voice is resampled at 8.9 kHz, so when the file is played at
   voice modem speed, 9.6 kHz, she speeds up just a bit.
}
   "fft" exists? not IF " Require FFT words" . nl halt THEN

   "PHONE_PLAY" missing IF "vmo.v" source THEN
   "resample" missing IF "signal.v" source THEN
   "wavData" missing IF "snd.v" source THEN
   "play1" missing IF "say.v" source THEN

\  Using this file made in festival_demo (see above):
   "/usr/local/sound/irene_cat.wav" wavData drop (hT)

\  Data processing to reduce these 16 bits/sample, 16 kHz sound bytes 
\  into 8 bits/sample, 9.6 kHz for the voice modem.

\     Resample at 8900 Hz (played at 9600, Irene will speed up):
      (hT) LITTLE_ENDIAN import2 (hA)
      16000 8900 resample (hA)

\     Scale resampled 16 bit data to 8 bits per sample:
      list: -32768 32767 ; \ signed 2-byte ints
      list: 0      255   ; \ into unsigned 1-byte ints
      park (hXY) \ table for word lerp
      (hA hXY) swap lerp integer (hA) export1 (hT)

\  Playing the sound bytes on the stack:
      (hT) dup play 

\  Prepending a .wav header and writing a file:
      these bytes 8 9600 wavHeader (hH)
      (hT hH) swap cat (hT)
      scratch this deleteif dup push
      new binary "wav" this closeif open
      (hT) wav fput wav close

\  Playing over the phone:
\     scratch wav>rmd Num PHONE_PLAY

\  Making an rmd file for slow machine gutter:
      scratch wav>rmd
      "mv " swap cat spaced "/tmp/irene_cat.rmd"
      cat shell

   private halt

\-----------------------------------------------------------------------

   Obsolete.

  _inline: pair1000# (qN1N2 --- qN1_N2) \ quote number as pair 1000 /mod
\     5065 is "five oh sixty-five"
      number IF this 999 >
                IF 1000 /mod 
                   say# swap dup 99 >
                   IF say#
                   ELSE dup 9 >
                      IF "oh " swap say# cat
                      ELSE dup 0>
                         IF " oh oh " swap say# cat
                         ELSE drop " and 0"
                         THEN
                      THEN
                   THEN cat
                ELSE int$ quote#
                THEN
             ELSE undefined#
             THEN
   end

  _inline: fplay (qFile --- ) \ play sound File
\     Playing 8 byte sound at 9600 Hz for up to 300 seconds using
\     playprog.
      [ playprog " -t 300 -b 8 -s 9600 " cat says Play ]
      no STR stkok not IF "fplay" stknot return THEN

      this file? not
      IF " fplay: file not found: " swap cat ersys return THEN

      " Playing " over cat . sp sp
      Play swap cat shell
   end

