\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2008  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{ File snd.v  August 2000

   Copyright (c) 2008   D. R. Williamson

   Working with sound.

   Some words use utility programs created when the mgetty distribution
   is installed.  Here are a couple of them, converting .au to generic
   .pfv (autopvf) and converting .pvf to raw modem data (pvftormd):

      [dale@clacker] /home/dale > which autopvf pvftormd
      /usr/local/bin/voice/autopvf
      /usr/local/bin/voice/pvftormd
   (The which command used above works because /usr/local/bin/voice/ is
   in this user's PATH.)

   Source for mgetty download:
      vgetty-maintainer@alphanet.ch

   The November 2002 distribution of mgetty:
      mgetty1.1.29-Nov25.tar.gz 983945 (bytes)

   Documentation:
      mgetty and vgetty man pages
      http://alpha.greenie.net/mgetty/index.html
      http://www.leo.org/~doering/mgetty/index.html

   Contents:

   syspath "snd.v" cat asciiload this " inline:" grepr reach dot

   inline: SND (qFile --- qPath+File)
   inline: LOAD_MORSE_CODE ( --- ) \ source Morse Code words
   inline: MC1 ( --- ) \ create Morse code at lower frequency tone
   inline: MC2 ( --- ) \ create Morse code at higher frequency tone

   inline: piano (qKey --- nHz) \ frequency (Hz) of Key
   inline: pMix (hA hB nS nD --- hC) \ add A to B delayed by D
   inline: pSilence (sec sam/sec --- hA) \ silence for sec
   inline: pTone (freq sec sam/sec --- hA) \ sine wave, unit amplitude
   inline: pToned (freq z sec sam/sec --- hA) \ damped sine, unit amp
   inline: silence (hT secs --- hT1) \ secs of silence
   inline: tone (hT freq secs --- hT1) \ secs of tone at freq
   inline: vmax8 (hV --- hU) \ scale vector V to max 8-bit sound level
   inline: vmax16 (hT --- hU) \ scale T to max 16-bit sound level

   inline: amplify8 (qWav --- qWav) \ amplify 8 bits/sample data
   inline: fplay (qFile b s --- ) \ play sound File
   inline: frecord (qS qFile ---  ) \ record quote S to File
   inline: play (hT --- ) \ play sound bytes
   inline: play1 (hT b s --- ) \ play sound bytes
   inline: record (qS --- hT) \ turn quote S to audio bytes
   inline: au>rmd (qAu --- qFileAu) \ .au file into .rmd file for modem
   inline: au>wav (qFauv --- qFileWav) \ .au file into .wav file
   inline: auData (qS --- hT hH) \ read au file header and data
   inline: auHeader (size encoding rate --- hH) \ header for au file
   inline: auWrite (hT hH qS --- ) \ writing an au formatted file
   inline: rmd>wav (qRmd --- qFileWav) \ .rmd file into .wav file
   inline: sndscratch ( --- qFile) \ a scratch file for sound conversion
   inline: tstrip (hT N --- hT1) \ strip N byte trailer
   inline: wav>au (qWav --- qFileAu) \ .wav file into .au file
   inline: wav>rmd (qWav --- qFileRmd) \ .wav file into .rmd file

   inline: ANNOUNCING ( --- )
   inline: ATTENTION ( --- ) \ immediate action required
   inline: BONG (n --- qWAV) \ makes a ringing TA-DA sound for n = 2
   inline: GONG (n --- qWAV) \ make GONG from BONG
   inline: RING ( --- ) \ rings if sound is working
   inline: TING (n --- qWAV) \ make TING from BONG

   inline: wavcat (qWav1 qWav2 --- qWav1) \ concatenate two wave files
   inline: wavData (qS --- hT hH) \ read wave file header and data
   inline: wavFile (hT --- qFile) \ sound bytes into wave file
   inline: wavFile1 (hT hH --- qFile) \ sound bytes into wave file
   inline: wavHdr (hFile --- hH) \ read wave file header for file handle
   inline: wavHeader (s bits/sam sam/sec --- hH) \ header for wave file
   inline: wavHeader1 (s bits/sam sam/sec --- hH) \ header for wave file
   inline: wavPlay (qWav --- ) \ play a .wav file
   inline: wavPlayb (qWav --- ) \ play a .wav file using Linux play()
   inline: wavPlayf (qWav --- ) \ play a .wav file using Linux play()
   inline: wavPSD (qFile --- hPSD hFreq) \ frequency content of sounds
   inline: wavque_add (qFile --- ) \ add wave File to wavque_play list
   inline: wavque_clr ( --- ) \ clear the queue in wavque_play()
   inline: wavque_play ( --- ) \ play the first file in the queue
   inline: wavque_start ( --- ) \ start the wave file queuing system
   inline: wavSilence (hH nsec --- hT) \ silence bytes for header H
   inline: wavTime (qS --- sec) \ time to play wave file S

   inline: CODE (qL --- hS) \ sounds for Morse code
   inline: mc ( --- ) \ practice Morse code
   inline: mcslow ( --- ) \ practice Morse code
   inline: SIG (qSIG n --- qWAV) \ qSIG repeated n times
   inline: WORD (qW --- hM) \ Morse code for word W
   inline: WORDS (qT --- hM) \ Morse code for words in T
}
\-----------------------------------------------------------------------

\  Instances in sound words requiring a specific voice modem type have 
\  been partitioned to ease conversion of this file to other types.

\  Separate definitions for these partitions are isolated here.

\  Modem string and bits/sample needed for mgetty sound file conversion
\  functions (run pvftormd -L; see example below in word wav>rmd):
      "ZyXEL_1496 2 " quoted "MODEM" inlinex \ author's voice modem

\  Place in this word the path to files that convert various sound file
\  formats.  The mgetty distribution installs them in /usr/local/bin.

   inline: SND (qFile --- qPath+File)
      [ "/usr/local/bin/voice/" is Path \ where voice.tgz puts them
      ] Path swap cat spaced ;

\-----------------------------------------------------------------------

\  Record and play voice sound files.

\  These programs are required by words record and play:

    \ A program that turns text into sounds (see Reference 1 in the
    \ Appendix, the rsynth program):
      "/usr/local/bin/voice/say" filefound IF "sayprog" book THEN

    \ A program that records and plays sounds (see Reference 2 in the
    \ Appendix); here it is just used to play:
      "/usr/local/bin/voice/splay" filefound IF "playprog" book THEN

      "sayprog" exists? not "playprog" exists? not or

      IF " snd.v: required programs for voice not found" . nl 
         " snd.v: some words will not work" . nl
      THEN

\  Where some sound files are located:
   'syspath "../usr/voice/" + ' "SPATH" macro
   "'/usr/local/sound/archive/'" "ARCH" macro \ author's machine

\-----------------------------------------------------------------------

   "hanning" missing IF "signal.v" source THEN
   "sine" missing IF "mmath.v" source THEN

{  Words to load the words for Morse Code.

   Morse code words in this file add about 3.7 Mb to catalog memory, 
   increasing it by almost a factor of 10 (run memcat), so they are
   not routinely loaded when this file is sourced.  

   They can be loaded separately when needed by running one of the 
   three words that follow.
}
   inline: LOAD_MORSE_CODE ( --- ) \ source Morse Code words
      [ yes "SHRILL" book ]
      syspath "snd.v" + "LOAD MORSE CODE" msource
   end

   inline: MC1 ( --- ) \ create Morse code at lower frequency tone
      no "LOAD_MORSE_CODE" "SHRILL" bank
      LOAD_MORSE_CODE
   end

   inline: MC2 ( --- ) \ create Morse code at higher frequency tone
      yes "LOAD_MORSE_CODE" "SHRILL" bank
      LOAD_MORSE_CODE
   end

\-----------------------------------------------------------------------

\  Making sounds.

   inline: piano (qKey --- nHz) \ frequency (Hz) of Key
{     Incoming Key string is one of the names in the second column
      below, for example "D4/E4" for key 43, D# above middle C.

      "C4" is middle C, and "A4" is A440: "a4" piano (440)
}     [
      {" From http://www.sengpielaudio.com/calculator-notenames.htm
        #Note number Key number     
        #English Note names
        #German Note names
        #Frequency in Hz
        88      C8      c'''''  4186,01
        87      B7      h''''   3951,07
        86      A7/B7   ais''''/b''''   3729,31
        85      A7      a''''   3520,00
        84      G7/A7   gis''''/ges''''         3322,44
        83      G7      g''''   3135,96
        82      F7/G7   fis''''/ges''''         2959,96
        81      F7      f''''   2793,83
        80      E7      e''''   2637,02
        79      D7/E7   dis''''/es''''  2489,02
        78      D7      d''''   2349,32
        77      C7/D7   cis''''/des''''         2217,46
        76      C7      c''''   2093,00
        75      B6      h'''    1975,53
        74      A6/B6   ais'''/b'''     1864,66
        73      A6      a'''    1760,00
        72      G6/A6   gis'''/as'''    1661,22
        71      G6      g'''    1567,98
        70      F6/G6   fis'''/ges'''   1479,98
        69      F6      f'''    1396,91
        68      E6      e'''    1318,51
        67      D6/E6   dis'''/es'''    1244,51
        66      D6      d'''    1174,66
        65      C6/D6   cis'''/des'''   1108,73
        64      C6      c'''    1046,50
        63      B5      h''     987,767
        62      A5/B5   ais''/b''       932,328
        61      A5      a''     880,000
        60      G5/A5   gis''/as''      830,609
        59      G5      g'      783,991
        58      F5/G5   fis''/ges''     739,989
        57      F5      f'      698,456
        56      E5      e'      659,255
        55      D5/E5   dis''/es''      622,254
        54      D5      d''     587,330
        53      C5/D5   cis''/des''     554,365
        52      C5      c''     523,251
        51      B4      h'      493,883
        50      A4/B4   ais'/b'         466,164
        49      A4 concert pitch        a' Kammerton    440,000
        48      G4/A4   gis'/as'        415,305
        47      G4      g'      391,995
        46      F4/G4   fis'/ges'       369,994
        45      F4      f'      349,228
        44      E4      e'      329,628
        43      D4/E4   dis'/es'        311,127
        42      D4      d'      293,665
        41      C4/D4   cis'/des'       277,183
        40      C4 (middle C)   c' (Schloss-C)  261,626
        39      B3      h       246,942
        38      A3/B3   ais/b   233,082
        37      A3      a       220,000
        36      G3/A3   gis/as  207,652
        35      G3      g       195,998
        34      F3/G3   fis/ges         184,997
        33      F3      f       174,614
        32      E3      e       164,814
        31      D3/E3   dis/es  155,563
        30      D3      d       146,832
        29      C3/D3   cis/des         138,591
        28      C3      c       130,813
        27      B2      H       123,471
        26      A2/B2   Ais/B   116,541
        25      A2      A       110,000
        24      G2/A2   Gis/As  103,826
        23      G2      G       97,9989
        22      F2/G2   Fis/Ges         92,4986
        21      F2      F       87,3071
        20      E2      E       82,4069
        19      D2/E2   Dis/es  77,7817
        18      D2      D       73,4162
        17      C2/D2   Cis/Des         69,2957
        16      C2      C       65,4064
        15      B1      H1      61,7354
        14      A1/B1   Ais1/b1         58,2705
        13      A1      A1      55,0000
        12      G1/A1   Gis1/As1        51,9130
        11      G1      G1      48,9995
        10      F1/G1   Fis1/Ges1       46,2493
        9       F1      F1      43,6536
        8       E1      E1      41,2035
        7       D1/E1   Dis1/Es1        38,8909
        6       D1      D1      36,7081
        5       C1/D1   Cis1/Des1       34,6479
        4       C1      C1      32,7032
        3       B0      H2      30,8677
        2       A0/B0   Ais2/B2         29,1353
        1       A0      A2      27,5000
      "} "#" "" qreplace asciify noblanklines (hT)

         (hT) dup 2nd word drop (hNames)
         (hNames) vol2mat bend 1 those rows items park yes sort
         "XY" book \ key name lookup table

         (hT) "," "." strp 2 matread 2nd catch "HZ" book \ key freq, Hz
{
\        Examples.

\        This checks A 440:

         "piano" missing IF "snd.v" source THEN
         "wPSD" missing IF "signal.v" source THEN

         5510 "S" book \ sample rate
         "A4" piano 0.0008 9 S pToned "A" book \ need 9 secs for low S
         one S slash, A rows uniform makes t \ times

         A t plot
         A S t rows wPSD (hPSD hF) \ first row is 0
         2nd over rows 1- items reach "F" book \ remove 0 for log func
         2nd over rows 1- items reach "PSD" book

       \ Semi-log plot.
       \ With cursor arror on the spike, clicking left button 
       \ shows X = 440:
         PSD log10 F plot \ spike at 440 Hz in semilog plot

         "piano" missing IF "snd.v" source THEN
         "wPSD" missing IF "signal.v" source THEN

         5510 "S" book              \ sample rate
         0 16 S wavHeader1 "H" book \ skeleton 16 bit wave file header
         32767 "AMP" book           \ amplitude max for 16 bit sound
         4 "t" book                 \ seconds per note
         0.001 "c" book             \ critical damping ratio (.1%)
         0.4 "dt" book              \ initial delay (seconds)

       \ Piano scale from Middle C:
         "C4" piano c     t S pToned
         "D4" piano c     t S pToned       S dt     pMix
         "E4" piano c     t S pToned       S dt 2 * pMix
         "F4" piano c     t S pToned       S dt 3 * pMix 
         "G4" piano c     t S pToned       S dt 4 * pMix
         "A4" piano c     t S pToned       S dt 5 * pMix 
         "B4" piano c     t S pToned       S dt 6 * pMix 
         "C5" piano c     t S pToned       S dt 7 * pMix
         2 S pSilence                      S dt 8 * pMix
         dup abs maxfetch 2drop / AMP * 
         LITTLE_ENDIAN export2 H wavFile1 wavPlayb

       \ The open strings of a guitar:
         "E3" piano c     t S pToned
         "A3" piano c     t S pToned       S dt     pMix
         "D4" piano c     t S pToned       S dt 2 * pMix
         "G4" piano c     t S pToned 0.2 * S dt 3 * pMix \ 20% amplitude
         "B4" piano c     t S pToned       S dt 4 * pMix
         "E5" piano c 3 / t S pToned       S dt 5 * pMix \ 1/3 damping
         dup abs maxfetch 2drop / AMP * 
         LITTLE_ENDIAN export2 H wavFile1 wavPlayb

}     ]
      XY dup rot uppercase strchop str2num bsearch (r f)
      IF (hXY r) ndx 2nd fetch HZ swap pry
      ELSE (hXY r) 2drop " piano: key name not found" . nl
      THEN
   end

   inline: pMix (hA hB nS nD --- hC) \ add A to B delayed by D
{     Make sound C by adding sound A to sound B delayed by D seconds.
      Sounds A, B and C all have sample rate S.

      Sound C is the longest of sound A or delay D plus sound B.

      Example usage is shown in word piano.

}     "D" book "S" book

      D S pSilence (hS) swap (hS hB) pile

      (hA hB) over rows over rows (rA rB) >
      IF over rows over rows - 1 null pile \ extend B+D to A
      ELSE swap over rows over rows - 1 null pile swap \ extend A to B+D
      THEN (hA hB) + (hC)
   end

   inline: pSilence (sec sam/sec --- hA) \ silence for sec
      (sec sam/sec) * (N) 1 null
   end

   inline: pTone (freq sec sam/sec --- hA) \ sine wave, unit amplitude
\     Unit amplitude sine.

      1 over / "dt" book
      (sec sam/sec) * "N" book
      (freq) rad/cyc * "W" book
      1 W 0 dt N sine (hA ht) drop (hA)
   end

   inline: pToned (freq z sec sam/sec --- hA) \ damped sine, unit amp
\     Unit amplitude damped sine.
\     Example usage is shown in word piano.

      1 over / "dt" book
      (sec sam/sec) * "N" book
      (z) "Z" book
      (freq) rad/cyc * "W" book
      1 W Z 0 dt N sined (hA ht) drop (hA)
   end

   inline: silence (hT secs --- hT1) \ secs of silence
      [ \ Bank ahead of time the sample rate, bits per sample and
        \ silence byte.  These are the initial values:

             9600 into nSamplesPerSec (samples/sec)
             8 into wBitsPerSample (bits/sample)
             127 into Silence
      ]
      nSamplesPerSec star
      wBitsPerSample star 8 slash (bytes)
      Silence export1 swap cats (hSilence)
      (hT hSilence) cat (hT1)
   end

   inline: tone (hT freq secs --- hT1) \ secs of tone at freq
      [ \ Bank ahead of time the sample rate and bits per sample.
        \ These are the initial values:

             9600 into nSamplesPerSec (samples/sec)
             8 into wBitsPerSample (bits/sample)

             100 into A8
             30000 into A16
        {
           Tone demo
           (assumes word silence has same sample rate and bits/sample)

           "playprog" missing IF "snd.v" source THEN "playprog" missing
           IF " tone: require program splay" . nl halt THEN

            "" 
            440 .2 tone .2 silence 880 .1 tone
            440 .2 tone .2 silence 880 .1 tone
      
            (hT) these bytes
            "tone" "wBitsPerSample" yank
            "tone" "nSamplesPerSec" yank
            wavHeader swap cat
      
            "tone" "wBitsPerSample" yank
            "tone" "nSamplesPerSec" yank
            play1
            
            end
        }
      ]
      true 
      3 STR stkok or, 3 VOL stkok or,
      1 NUM stkok and, 2 NUM stkok and, not
      IF "tone" stknot return THEN

      (secs) nSamplesPerSec * (N) push

      wBitsPerSample 8 =
      IF A8 ELSE A16 THEN (A)

      (A) swap (freq) 2pi * (w) 0 (phi) 1 nSamplesPerSec / (dt)
      (A w phi dt) pull (N) sine (hA ht) hanning *by (hA)

      wBitsPerSample 8 =
      IF (hA) export1 ELSE LITTLE_ENDIAN export2 THEN (hT1)

      (hT hT1) cat
   end

   inline: vmax8 (hV --- hW) \ scale vector V to max 8-bit sound level
\     V and W are column vectors, type MAT.
      [ 255 "AMP" book ] \ amplitude max for 8-bit sound
      (hV) dup minfetch 2drop abs + \ make V unsigned
      (hV) AMP over maxfetch 2drop / * (hW)
   end

   inline: vmax16 (hT --- hU) \ scale T to max 16-bit sound level
\     Note difference with vmax8.  Here, incoming T is a string of 
\     sound bytes that must first be converted into a MAT, while in 
\     vmax8 incoming V is already a MAT and outgoing W remains a MAT.
      [ 32767 "AMP" book ] \ amplitude max for 16 bit sound
      (hT) hand LITTLE_ENDIAN import2 (hV)     \ sound into MAT
      (hV) dup abs maxfetch 2drop / AMP * (hV) \ scale MAT
      (hV) LITTLE_ENDIAN export2 (hU)          \ MAT into sound
   end

\-----------------------------------------------------------------------

\  Playing and recording.

   inline: amplify8 (qWav --- qWav) \ amplify 8 bits/sample data
      [ no is File,  ]
      File filetrue IF File fclose THEN
      (qWav) "Name" book

      Name wavData push uimport1
      255 that abs maxfetch 2drop (max) slash *f export1

      these chars (s)
      peek 11 ndx pry (bits/sample)
      pull 8 ndx pry (samples/sec)
      (hT s bit/samp samp/sec) wavHeader swap cat

      Name delete
      Name new binary "File" open
      (hT) File fput
      File fclose
      Name
   end

   inline: fplay (qFile b s --- ) \ play sound File
\     Playing b bit sound at s Hz for up to 600 seconds using playprog.

\     Any header on File is ignored (in fact, it is played, which makes
\     for a scratch at the beginning).

      (s) this 1000 < IF 1000 * THEN (s)
      (s) " -s " swap int$ cat
      (b) " -b " rot  int$ cat cat
      "playprog" main " -t 600" cat swap cat spaced

      that file? not
      IF " fplay: file not found: " other cat ersys return THEN

      " Playing " other cat . sp sp

      swap (" &" cat) cat shell
   end

   inline: frecord (qS qFile ---  ) \ record quote S to File
{     Records 8 bit sound using sayprog (the rsynth program), and
      prepends a header for a wave file at voice modem speed.

      WARNINGS: The rsynth program is hardwired to write to file tmp,
      so an error will occur if there is a directory tmp/ in the cur-
      rent directory.  Also, if there is a file called tmp, it will be 
      overwritten.

      Recording is done at one speed (HZ) and the voice modem speed
      placed the .wav header can be another (moHZ).

      If the header is not used, as in word record, then moHz is not
      used.

      Initial built-in speeds can be changed by banking other values,
      as:
          9600 "frecord" "HZ"   bank
          9600 "frecord" "moHZ" bank
}
      [ "tmp" is File \ the file sayprog (rsynth) always writes to

        'echo " " > ' File cat makes Touch
        sayprog " -r " cat says Say

        9600 "HZ" book \ recording speed
        9600 "moHZ" book \ voice modem speed

        no is hFile
      ]
      "tmp" dir? 
      IF " frecord: cannot record in a directory that contains tmp/"
         . nl return
      THEN

      true 1 STR stkok and, 2 STR stkok and, not
      IF "frecord" stknot return THEN

      hFile filetrue IF hFile fclose THEN
      (qFile) this deleteif \ remove existing File

      " Recording " that cat nl dot sp sp
      push push Touch
      Say HZ int$ cat spaced
      pull (qS) quoted cat pile
\     Running sayprog (rsynth), which makes a headerless sound file
\     at 8 bits/sample:
      (hT) shell

\     Make a wave file header at voice modem speed and prepend the
\     header to the sound bytes:
      File old binary 'hFile' file
      hFile INF fget (hT) \ recorded bytes to stack
      (hT) these bytes 8 (bits/sample) moHZ wavHeader swap cat (hT)

      hFile fclose, File delete

      pull (qFile) new binary "hFile" file
      (hT) hFile fput \ saving file named qFile
      hFile fclose
   end

   inline: play (hT --- ) \ play sound bytes
\     Playing 8 bit sound at 9600 Hz using word fplay.
      [ "_bin" "tmppath" yank runid cat "_play.tmp" cat is File
        no is hFile, 8 is BITS, 9600 is HZ 
      ]
      no VOL stkok not IF "play" stknot return THEN

      hFile filetrue IF hFile close THEN File deleteif
      File new binary "hFile" open (hT) hFile fput

      File BITS HZ fplay
      hFile close File delete
   end

   inline: play1 (hT b s --- ) \ play sound bytes
\     Playing b bit sound at s Hz using word fplay.

      "play" "HZ"   yank "HZ"   book
      "play" "BITS" yank "BITS" book

      (s) "play" "HZ"   bank
      (b) "play" "BITS" bank

      play

      HZ   "play" "HZ"   bank
      BITS "play" "BITS" bank
   end

   inline: record (qS --- hT) \ turn quote S to audio bytes
\     Recording 8 bit sound using sayprog (rsynth).

      (qS) scratch frecord

      scratch wavData (hT hH) drop
      "_rsynth" naming

      scratch delete
   end

\-----------------------------------------------------------------------

\  Sound file data and conversion.

   inline: au>rmd (qAu --- qFileAu) \ .au file into .rmd file for modem
\     Using functions from mgetty: autopvf and pvftormd.
      [ "_bin" "tmppath" yank runid cat ".autormd" cat makes RMD ]
      "AU" book
      "autopvf" SND AU spaced sndscratch cat cat shell
      RMD deleteif
      "pvftormd" SND MODEM spaced sndscratch spaced 
      RMD cat cat cat shell
      sndscratch delete
      RMD
   end

   inline: au>wav (qFauv --- qFileWav) \ .au file into .wav file
\     Using functions from mgetty: autopvf and pvftowav.
      [ "_bin" "tmppath" yank runid cat ".autowav" cat makes WAV ]
      "AU" book
      "autopvf" SND AU spaced sndscratch cat cat shell
      WAV deleteif
      "pvftowav" SND sndscratch spaced WAV cat cat shell
      sndscratch delete
      WAV
   end

   inline: auData (qS --- hT hH) \ read au file header and data
{     Reading file S in Sun audio (au) file format.
      Returned matrix H holds 6 numerical header values; returned
      volume T (1-by-N) contains N data bytes, unchanged.
      Does not return comment--if any--contained in the header.

      au format:
         Ref: http://raiden.goice.co.jp/member/mo/formats/au.html
         big-endian byte order
         Item  Offset  Bytes  Contents
          1      0        4    ".snd"
          2      4        4    Header size, h
          3      8        4    Sample data size, s
          4     12        4    Audio file encoding (see Ref)
          5     16        4    Sample rate
          6     20        4    Number of channels
          7     24     h-24    Comment
          8      h        s    Sample data
}
      [ ".snd" makes sunmagic ]
      [ scalar "au" book ] au filetrue IF au fclose THEN
      no STR stkok not IF "auData" stknot return THEN

      this file? not IF " file not found: " . . return THEN
      (qS) old binary "au" file

      au four fget 1st quote sunmagic alike not
      IF " au format header not found" . au fclose return THEN

      au dup rewind 24 fget BIG_ENDIAN import4 (hH)

      au that (hH) 2nd pry (offset) fseek
      au that (hH) 3rd pry (size) fget (hT)

      "_auSampleData" naming (hT) swap "_auHeader" naming (hH)
      au fclose
   end

   inline: auHeader (size encoding rate --- hH) \ header for au file
\     Note: au header format is shown in word auData.
\     This word assumes one channel.
      [ "'auData' 'sunmagic' localpry" "sunmagic" inlinex ]
      [ 6 is n (items), n 4 * is h (header bytes) ]
      n one null push
      (.snd) sunmagic str2vol BIG_ENDIAN import4 ontop, peek 1st poke
      (header size) h, peek 2nd poke
      (rate), peek five ndx poke
      (encoding), peek four ndx poke
      (size), peek 3rd poke
      (channels) one, peek six ndx poke
      pull "_auHeader" naming
   end

   inline: auWrite (hT hH qS --- ) \ writing an au formatted file
\     Writing Sun Audio File Format.
\     Note: Sample data size in header H (3rd item) is ignored, 
\     and actual size of data T is written in header H.
      [ scalar "au" book ] au filetrue IF au fclose THEN
      no STR stkok not IF "auWrite" stknot return THEN
      (qS) forn binary "au" file
      (hT hH) those dims star (size) that 3rd poke \ T size into H
      (hT hH) BIG_ENDIAN export4 au fput
      (hT) au fput
      au fclose
   end

   inline: rmd>wav (qRmd --- qFileWav) \ .rmd file into .wav file
{     Using functions from mgetty: rmdtopvf and pvftowav.
 
      /usr/local/bin/voice > rmdtopvf -h
      rmdtopvf experimental test release 0.9.32 / 24Dec01
      usage:
        rmdtopvf [options] [<rmdfile> [<pvffile>]]

      options:
        -h     this help message
        -L     list of supported raw modem data formats
        -a     output pvf ascii format
        -b     output pvf binary format (default)
        -8     output 8 bit samples
        -16    output 16 bit samples
        -32    output 32 bit samples (default)
}
      [ "_bin" "tmppath" yank runid cat ".rmdtowav" cat makes WAV ]
      "RMD" book
      "rmdtopvf" SND "-8 " cat RMD spaced sndscratch cat cat shell
      WAV deleteif
      "pvftowav" SND spaced sndscratch spaced 
      WAV cat cat shell
      sndscratch delete
      WAV 
   end

   inline: sndscratch ( --- qFile) \ a scratch file for sound conversion
      [ "_bin" "tmppath" yank runid cat "snd.tmp" cat makes sndscratch ]
      sndscratch
   end

   inline: tstrip (hT N --- hT1) \ strip N byte trailer
      "N" book 1st over chars N - 1 max items catch
   end

   inline: wav>au (qWav --- qFileAu) \ .wav file into .au file
\     Using functions from mgetty: wavtopvf and pvftoau.
      [ "_bin" "tmppath" yank runid cat ".wavtoau" cat makes AU ]
      "WAV" book
      "wavtopvf" SND WAV spaced sndscratch cat cat shell
      "pvftoau" SND sndscratch spaced AU cat cat shell
      sndscratch delete
      AU
   end

   inline: wav>rmd (qWav --- qFileRmd) \ .wav file into .rmd file
{     Using functions from mgetty: wavtopvf and pvftormd.
 
      /usr/local/bin/voice > pvftormd -h
      pvftormd experimental test release 0.9.32 / 24Dec01

      usage:
        pvftormd <modem type> <compression method> \
          [options] [<pvffile> [<rmdfile>]]
      options:
        -h     this help message
        -L     list of supported raw modem data formats
               and compression methods

      Note: -L option provides the list needed to make word MODEM.
}
      [ "_bin" "tmppath" yank runid cat ".wavtormd" cat makes RMD ]
      "WAV" book
      "wavtopvf" SND WAV spaced sndscratch cat cat shell
      RMD deleteif
      "pvftormd" SND MODEM spaced sndscratch spaced 
      RMD cat cat cat shell
      sndscratch delete
      RMD
   end

\-----------------------------------------------------------------------

\  Working with .wav files.

   inline: ANNOUNCING ( --- ) 
      2 BONG dup wavPlayf delete ;

   inline: ATTENTION ( --- ) \ immediate action required
      [ {" ( --- qFile)
          1 "R" book   \ factor on sample rate
          2.5 "A" book \ factor on amplitude

        \ Assemble the sound bytes:
          SPATH "ALARM1.WAV" + wavData swap
          dup chars nulls hand dup "SILENCE" book +
          LITTLE_ENDIAN import2 A * LITTLE_ENDIAN export2 
          3 clone SILENCE + swap (hT hH)

        \ Factor the header sample rate:
          (hT hH) push
          peek 8 pry R * peek 8 poke
          peek 9 pry R * peek 9 poke pull 

          (hT hH) wavFile1 (qFile)

          (qFile) dup wavTime 1.1 * "DELAY" book
        "} "MAKEFILE" macro
      ]
      MAKEFILE "FILE" book
      FILE wavPlayb 

      "Press a key for Off" . nl
      BEGIN
         DELAY getch1 0=
         IF FILE wavPlayb false
         ELSE true "Off" . nl
         THEN
      UNTIL

      FILE delete
   end

   inline: BONG (n --- qWAV) \ makes a ringing TA-DA sound for n = 2
\     Example: 2 BONG wavPlayb

      [ 48 "TA" book ] \ higher TA shortens the period of TA in TA-DA
      "n" book
      SPATH "BONG1.WAV" + wavData swap

      dup chars TA / split (hLeft hRight) swap n clone swap +
      LITTLE_ENDIAN import2 32500 25116 / * LITTLE_ENDIAN export2

      swap wavFile1
   end

   inline: GONG (n --- qWAV) \ make GONG from BONG
\     Example: 2 GONG wavPlayb
\     See example in word wavque_play().

      [ 12 "TA" book ] \ higher TA shortens the period of TA in TA-DA
      "n" book
      SPATH "BONG1.WAV" + wavData swap

      dup chars TA / split (hLeft hRight) swap n clone swap +
      LITTLE_ENDIAN import2 32767 25116 / * LITTLE_ENDIAN export2

    \ Halve the BONG1.WAV sample rate of 11025 samples/second.  A value
    \ near 5512.5 that is acceptable to sox is 5510 samples/second:
      swap (hHDR) push 
      5510     peek (n hHDR) 8 poke \ samples per second
      5510 2 * peek (n hHDR) 9 poke \ bytes per second @ 2 bytes/sample

      pull (hT hH) wavFile1 
   end

   inline: RING ( --- ) \ rings if sound is working
      [ {" ( --- qWav)
           128 "wavSilence" "bSilence" bank

           SPATH "RING1.WAV" + wavData swap 80 tstrip
           over .5 wavSilence + swap (hT hH) wavFile1

           0 "wavSilence" "bSilence" bank
        "} "MAKEFILE" macro
      ]
      MAKEFILE dup "FILE" book wavPlayf
      FILE delete
   end

   inline: TING (n --- qWAV) \ make TING from BONG
\     Example: 2 TING wavPlayb

      [ 24 "TA" book ] \ higher TA shortens the period of TA in TA-DA
      "n" book
      SPATH "BONG1.WAV" + wavData swap

      dup chars TA / split (hLeft hRight) swap n clone swap +
      LITTLE_ENDIAN import2 32767 25116 / * LITTLE_ENDIAN export2

    \ Double the header elements involving sample rate:
      swap (hHDR) push 
      peek (hHDR) 8 pry 2 * peek 8 poke
      peek (hHDR) 9 pry 2 * peek 9 poke

      pull wavFile1 
   end

   inline: wavcat (qWav1 qWav2 --- qWav1) \ concatenate two wave files
      [ no is File  
        "11 ndx pry" "Bits" inlinex
        " 8 ndx pry" "Rate" inlinex
      ]
      File filetrue IF File fclose THEN

      swap (qWav1)

      wavData (hT1 hH1)
      (hH1) dup Bits "wBitsPerSample" book \ bits/sample
      (hH1) Rate "nSamplesPerSec" book     \ samples/sec

      swap wavData (hT2 hH2)
      (hH2) dup Bits wBitsPerSample <>
      swap (hH2) Rate nSamplesPerSec <> or

      IF " wavcat: sound files are incompatible" ersys return THEN

      (hT1 hT2) cat (hT)

\     Append the sound bytes to a wave file header:
      (hT) these bytes (s)
      wBitsPerSample (bits/sample)
      nSamplesPerSec (samples/sec) wavHeader (hH)
      swap (hH hT) cat (hT)

      ftempsys "Name" book
      Name old binary "File" open
      (hT) File fput
      File fclose
      Name
   end

   inline: wavData (qS --- hT hH) \ read wave file header and data
\     Read file S in Microsoft PCM file format.
      [ "RIFF" makes wavmagic ]
      [ no "wav" book ] wav filetrue IF wav fclose THEN
      no STR stkok not IF "wavData" stknot return THEN

      this file? not IF " file not found: " . . return THEN
      (qS) old binary "wav" file

      wav four fget 1st quote wavmagic alike not
      IF " wav format header not found" . wav fclose return THEN

      wav rewind 
      wav wavHdr
      wav INF fget (hData) swap (hT hH)
      wav fclose
   end

   inline: wavFile (hT --- qFile) \ sound bytes into wave file
\     Used when working with the voice modem (see vmo.v).

\     Bytes of T are not changed.  This word simply appends bytes of T
\     to a .wav header, using /sample bits per sample and sample rate 
\     from moHz of word frecord.
      [ \ The name of the file returned by this word:
        "_bin" "tmppath" yank runid cat "wafile.tmp" cat makes DATA

        no is hFile \ file handle

        8 (bits/sample) "/sample" book

\       NOTE: using value of moHZ from frecord for the sample rate
      ]
      DATA deleteif

\     Make a wave file header at voice modem speed and append the
\     sound bytes to it:
      (hT) these bytes /sample
      "frecord" "moHZ" yank wavHeader swap cat (hT)

\     Save a sound file and return its name on the stack:
      (hT) DATA (qFile) forn binary "hFile" file
      (hT) hFile fput \ saving file named qFile

      hFile fclose DATA
   end

   inline: wavFile1 (hT hH --- qFile) \ sound bytes into wave file
{     Bytes of T are not changed.  Before writing File, this word
      appends T to a .wav header made from incoming header H with
      modified length parameters at Items 2 and 13 to correspond 
      to the size of T (see Items in word wavHdr() mapping table).

      If error, returned File is an empty string.

      Returned File is temporary and will be deleted when the program 
      exits.
}
      [ no "BIN" book

      \ The name of the file returned by this word begins with these
      \ characters:
        "_bin" "tmppath" yank runid + "_" + "FIL" book

        "LITTLE_ENDIAN export4" "DWORD" macro
        "LITTLE_ENDIAN export2" "WORD"  macro
        "1st 4 items catch"     "TEXT"  macro
      ]

      (hT hH) swap (hT) dup sizeof "Tlen" book (hT)
      (hH hT) push push

    \ Assemble the header:
      peek 1st pry num2str TEXT      \ "RIFF"

    \ Assume H(2) = Tlen + 36 (bytes):
      Tlen 36 + DWORD              + \ len+chunk (item 2)

      peek 3rd pry num2str TEXT    + \ "WAVE"
      peek 4th pry num2str TEXT    + \ "fmt "
      peek 5 ndx pry DWORD         + \ format chunk size
      peek 6 ndx pry WORD          + \ wFormatTag
      peek 7 ndx pry WORD          + \ nChannels
      peek 8 ndx pry DWORD         + \ nSamplesPerSec
      peek 9 ndx pry DWORD         + \ nAvgBytesPerSec
      peek 10 ndx pry WORD         + \ nBlockAlign
      peek 11 ndx pry WORD         + \ wBitsPerSample
      pull 12 ndx pry num2str TEXT + \ "data"

    \ Assume H(13) = Tlen - 78 (bytes):
      Tlen 78 - DWORD              + \ len (item 13)

    \ Append the data:
      (hH) pull (hT) + (hT)

      BIN filetrue IF BIN fclose THEN

\     Make a temporary sound file and return name on the stack; return
\     an empty string if there is an error; and do extra error moni-
\     toring to ensure a good file is returned:

      (hT) binary FIL "BIN" filetemp (qFile1)

      BIN rows 0= \ monitor the rows in handle, BIN; 0= means error

      IF (qFile1) drop 
         " wavFile1: error opening file" . nl "" (qEmpty)
      ELSE
         ercnt push \ monitor the error count when writing 

         (hT qFile1) swap BIN fput \ writing file named qFile
         BIN fclose 
         (qFile1)

         ercnt pull <> \ has error count changed?
         IF (qFile1) deleteif "" (qEmpty)
            " wavFile1: error writing file" . nl "" (qEmpty)
         THEN
      THEN (qFile)
   end

   inline: wavHdr (hFile --- hH) \ read wave file header for file handle
{     Read header of file S in Microsoft PCM file format, and return
      a matrix.

      Returned matrix H holds numerical header values; string elements
      in H are intact, the program just thinks they are 8-byte numbers.
      For example, RIFF looks like this:
         [tops@riggo] ready > "RIFF" str2num dup . nl dup .hex nl \
                              num2str . (back to string)
          6.0135E-154
          52 49 46 46 20 20 20 20 [in hex, letters R I F F and 4 blanks]
         RIFF    
         [tops@plunger] ready > 

      wav format:
         References: 
            1) http://msdn.microsoft.com/archive/default.asp?url=
                 /archive/en-us/dx8_c/directx_cpp/dsound_struct_4hwv.asp
            2) mgetty/mgetty-1.1.29/voice/libpvf/wav.c, function 
               wavwritehdr()
            3) mgetty/mgetty-1.1.29/voice/include/wav.h

         Note: File wav.c noted in Reference 2 deals with many wave 
         file forms.  This word, wavHdr, is aimed only at simple sound
         files for speech. 

         Example sizes from a .wav file header:
               -rw------- 1 dale dale 371760 Feb 22 11:19 intro.wav

       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  52 49 46 46 28 AC 05 00 57 41 56 45 66 6D 74 20  RIFF(...WAVEfmt
   2  10 00 00 00 01 00 01 00 80 3E 00 00 00 7D 00 00  .........>...}..
   4  02 00 10 00 64 61 74 61 04 AC 05 00 F7 FF FA FF  ....data........
   6  F9 FF F9 FF FA FF F8 FF F7 FF F5 FF F7 FF F8 FF  ................

            Header bytes 4-7 (0 based) give the value:
              28 AC 05 00 = 5*16^4 + A*16^3 + C*16^2 + 2*16 + 8 = 371752

            Header bytes 40-43 give the value:
              04 AC 05 00 = 5*16^4 + A*16^3 + C*16^2 + 0*16 + 4 = 371716

            Delta = 371752 - 371716 = 36
            File wav.c (Reference 2) uses 8+16+12+1 = 37 in the files
            it writes.

            Conclude for this example: 
               Header bytes 4-7 give file size less 8 bytes
               Header bytes 40-43 give data length

         Typical SamplesPerSec at offset 24:
            16000: 80 3E
             9600: 80 25 (ZyXEL voice modem)
             8000: 40 1F

         Numbers are in little-endian byte order

         Item Offset Bytes Contents
          1     0      4   "RIFF"
          2     4      4   Waveform chunk size: [data_length+8+16+12+1]
          3     8      4   "WAVE"
          4    12      4   "fmt "
          5    16      4   Format chunk size (10h)
          6    20      2   WORD  wFormatTag
          7    22      2   WORD  nChannels
          8    24      4   DWORD nSamplesPerSec (80 3E = 16000)
          9    28      4   DWORD nAvgBytesPerSec
          10   32      2   WORD  nBlockAlign
          11   34      2   WORD  wBitsPerSample
          12   36      4   "data" Ignored for WAVE_FORMAT_PCM formats
          13   40      4   Data length (data chunk size), s
          14   44      s   Data 

         Note: Items 5-11 correspond to struct WAVEFORMATEX in 
         Reference 1.
}
      (hFile) dup filetrue
      IF (hFile) "WAV" book
         WAV rewind
         list: \ Reading wave file header, 13 items
            WAV four fget 1st quote str2num       \ "RIFF"
            WAV four fget LITTLE_ENDIAN import4 @ \ waveform chunk size
            WAV four fget 1st quote str2num       \ "WAVE"
            WAV four fget 1st quote str2num       \ "fmt"
            WAV four fget LITTLE_ENDIAN import4 @ \ Format chunk size
            WAV two  fget LITTLE_ENDIAN import2 @ \ wFormatTag
            WAV two  fget LITTLE_ENDIAN import2 @ \ nChannels
            WAV four fget LITTLE_ENDIAN import4 @ \ nSamplesPerSec
            WAV four fget LITTLE_ENDIAN import4 @ \ nAvgBytesPerSec
            WAV two  fget LITTLE_ENDIAN import2 @ \ nBlockAlign
            WAV two  fget LITTLE_ENDIAN import2 @ \ wBitsPerSample
            WAV four fget 1st quote str2num       \ "data"
            WAV four fget LITTLE_ENDIAN import4 @ \ data length, s
         end (hHeader)
      ELSE (hFile) drop " wavHdr: invalid file handle" . nl purged
      THEN (hHeader)
   end

   inline: wavHeader (s bits/sam sam/sec --- hH) \ header for wave file
{     Returned H is a string of bytes exactly as in a wave file header.

      Note: the wave file header format is shown in word wavHdr.
      This word makes assumptions about most items in the header.
}
      [ "LITTLE_ENDIAN export2" "WORD" inlinex
        "LITTLE_ENDIAN export4" "DWORD" inlinex

        "wavData" "wavmagic" yank "RIFF" book
        "WAVE" "WAVE" book
        "fmt " "fmt" book
        1  WORD  "nChannels" book
        1  WORD  "nBlockAlign" book
        16 DWORD "Format_chunk_size" book
        1  WORD  "wFormatTag" book
        "data" "data" book
      ]
      2dup * (bits/sec) 8 / DWORD "nAvgBytesPerSec" book
      (sam/sec) DWORD "nSamplesPerSec" book
      (bits/sam) WORD "wBitsPerSample" book
      (s) "data_length" book

      depth push

    \ Item  Contents
      (1)   RIFF 
      (2)   data_length 37 + DWORD \ data_length+8+16+12+1
      (3)   WAVE
      (4)   fmt
      (5)   Format_chunk_size
      (6)   wFormatTag 
      (7)   nChannels
      (8)   nSamplesPerSec
      (9)   nAvgBytesPerSec
      (10)  nBlockAlign
      (11)  wBitsPerSample
      (12)  data
      (13)  data_length (78 -) DWORD
 
      depth pull less nit 1st DO cat LOOP
   end

   inline: wavHeader1 (s bits/sam sam/sec --- hH) \ header for wave file
\     Returned header is in matrix form, for use with wavFile1.

\     Make header string:
      (s bits/sam sam/sec) wavHeader (qS) 

\     Write header string to fake .wav file and read it with wavHdr():
      "" binary "BIN" filetemp (qFile) push
      (qS) hand BIN fput         \ write header string
      BIN rewind BIN wavHdr (hH) \ read header as matrix

\     Close its handle and delete temp file:
      BIN fclose pull (qFile) delete \ delete temp file

      (hH) \ return header matrix
   end

   inline: wavPlay (qWav --- ) \ play a .wav file
      [ 11 "wBitsPerSample" book  8 "nSamplesPerSec" book ]
      (qWav) wavData (hT hH)
      dup wBitsPerSample ndx pry (b)
      swap nSamplesPerSec ndx pry (s)
      (hT b s) play1
   end

   inline: wavPlayb (qWav --- ) \ play a .wav file using Linux play()
\     Plays in the background while the program moves on.  Works for 
\     files other than .wav.
      [ "/usr/bin/play" "FILE" book ]
      FILE filefound 
      IF spaced swap + " &" + shell \ using Linux sound file prog (sox)
      ELSE " wavPlayb: file not found: " FILE + . nl 
      THEN
   end

   inline: wavPlayf (qWav --- ) \ play a .wav file using Linux play()
\     Plays in the foreground.  Works for files other than .wav.
      [ "/usr/bin/play" "FILE" book ]
      FILE filefound 
      IF spaced swap + shell \ using Linux sound file program (sox)
      ELSE " wavPlayf: file not found: " FILE + . nl 
      THEN
   end

   inline: wavPSD (qFile --- hPSD hFreq) \ frequency content of sounds
{     Assumes 16 bit sound data.

      Example:
         1 GONG wavPSD (hPSD hFreq)
       \ Removing the initial zero frequency row for better plot:
         (hFreq) 2nd over rows 1- items reach (hFreq) swap
         (hPSD)  2nd over rows 1- items reach log10 (hPSDlog) swap 
       \ Making a semilog plot:
         (hPSDlog hFreq) plot
      
}     wavData (hT hH) 8 pry "S" book 
      (hT) LITTLE_ENDIAN import2 \ 16 bits per sample
      (hT) S over rows 4 / (Nf) 
      (hT S Nf) wPSD (hPSD hFreq)
   end

   inline: wavque_add (qFile --- ) \ add wave File to wavque_play list
    \ File is the name of a wave file; it is deleted after it plays.  
      any? IF (qFile) "wavque_play" "add" localrun THEN
   end

   inline: wavque_clr ( --- ) \ clear the queue in wavque_play()
    \ Empty the queue and the trash:
      "wavque_play" "queue" yank (hQ1) 
      "wavque_play" "trash" yank (hQ2) 
      (hQ1 hQ2) pile (hQ) any?
      IF (hQ) dup rows 1st
         DO dup (hQ) I quote deleteif LOOP drop
      THEN
      VOL tpurged (hQ) "wavque_play" "queue" bank
      VOL tpurged (hQ) "wavque_play" "trash" bank
   end

   inline: wavque_play ( --- ) \ play the first file in the queue
{     This word controls a queuing system to play successive wave files
      in the background (while the program moves on to other tasks) and
      is patterned after the job queuing system in file task.v.  

      It is for use in a system where the playing of two sound files may
      clash at any time.

      Trying to play two sound files at once causes this message:

         sox: Can't open output file '/dev/dsp': Device or resource busy

      and one will probably not be played.

      The wave file queuing system guarantees that only one file is 
      played at a time, and that all files will eventually be played.  
      It plays the first file in the queue and waits until NSEC seconds
      after it finishes before playing the next.

      Files played are piled in trash for eventual deletion, based on 
      the premise that they are program-generated signals that vary all
      the time.

      Rather than running

         (qFile) wavPlayb,

      a program uses the wave file queuing system by running the phrase

         (qFile) wavque_add

      and the file will be played by wavPlayb when its turn comes.

      Run word wavque_start to start the wave file queuing system. Its
      default rate, qRATE, is to check the queue once every 10 seconds.

      Here is an example that shows the wave file queue doesn't play 
      another sound until the one playing dies out:

         wavque_start
         2 GONG wavque_add
         2 BONG wavque_add
         2 TING wavque_add
         wavque_play 

      Note that while this example plays, the program responds to keys 
      and so is available to run other tasks and is not held up waiting
      for sounds to play.
}
      [ VOL tpurged (hQ) "queue" book
        VOL tpurged (hQ) "trash" book

        '(qFile) queue (hQ) swap pile "queue" book' "add" macro

        1 10 / "qRATE" (Hz) book \ multitasker rate of wavque_play 

      \ One second is calling it close if the timing is off, but
      \ try it (later: too close; increase to 2):
        2 "NSEC" book \ seconds delay before next file plays

      \ Running on an ALARM, this macro, QT, WAKEs this word (now
      \ SLEEPing) and also runs it; if there is another file in the 
      \ queue, it will start to play immediately:
        '"wavque_play" WAKE wavque_play' "QT" (qS qS1) macro 
      ]
      queue rows 0>
      IF "wavque_play" SLEEP \ stop the queuing system for now

       \ File to play:
         queue 1st quote (qFile)

       \ Play File in the background:
         dup (qFile) wavPlayb

       \ Set an ALARM to run local macro QT in d seconds, to WAKE the 
       \ queuing system when File stops playing and play the next file 
       \ in the queue: 
         (qFile) wavTime (nsec) NSEC + (d)
         (d) "wavque_play" "QT" localref ALARM

       \ Take out the trash:
         queue rows 1 >
         IF queue 1 over rows 1- 1 null pile rake (hQ0 hQ1) 
            (hQ1) trash pile "trash" book (hQ0) 
         ELSE queue trash pile "trash" book
            VOL tpurged (hQ)
         THEN (hQ) "queue" book

      ELSE trash any?
       \ Empty the trash:
         IF dup rows 1st 
            DO dup I quote deleteif LOOP drop
            VOL tpurged "trash" book 
         THEN
      THEN
   end

   inline: wavque_start ( --- ) \ start the wave file queuing system
      wavque_clr
      "wavque_play" dup "qRATE" yank swap PLAY \ start wave file queuing
   end

   inline: wavSilence (hH nsec --- hT) \ silence bytes for header H
{     Gets the samples per second and bits per sample from header H,
      then creates T with nsec seconds of silence.

      Assumes 0 is the byte for silence (bsilence; it isn't always; see
      word silence() above, and below in "Some tones and beeps" where 
      128 is used to generate some silence.

      In general, 16 bit data uses 0 for silence byte and 8 bit data 
      uses 128 for silence byte (where unsigned data ranges from 0 to
      255).
}
      [ 8 "nSamplesPerSec" book  \ row in H for sample rate
        11 "wBitsPerSample" book \ row in H for sample bits

        0 "bSilence" book \ one byte of silence
      {
         Calibrating:

            The following was run to get some calibration fudge factors
            for times from .01 to 10 seconds.

            HDR is a header from a typical .wav file that will be used 
            by this word.

            To run this section, HDR must be set (see word wavHdr()) 
            and then the following line will generate a calibration 
            matrix: 

               "snd.v" "CALIBRATE" msource 
        
            CALIBRATE 
               list:
                  0.01 (sec)
                  HDR 0.01 wavSilence 100 clone HDR wavFile1 
                  time push wavPlayf time pull - 100 / 

                  0.1 (sec)
                  HDR 0.1 wavSilence 100 clone HDR wavFile1 
                  time push wavPlayf time pull - 100 /

                  0.2 (sec)
                  HDR 0.2 wavSilence 10 clone HDR wavFile1 
                  time push wavPlayf time pull - 10 /

                  1 (sec)
                  HDR 1 wavSilence 10 clone HDR wavFile1 
                  time push wavPlayf time pull - 10 /

                  2 (sec)
                  HDR 2 wavSilence 10 clone HDR wavFile1 
                  time push wavPlayf time pull - 10 /

                  4 (sec)
                  HDR 4 wavSilence 3 clone HDR wavFile1
                  time push wavPlayf time pull - 3 /

                  10 (sec)
                  HDR 10 wavSilence 2 clone HDR wavFile1
                  time push wavPlayf time pull - 2 /
               end
               dup rows 2 / matrix (hXY)
               halt
      }
     \ For three test runs, this table compares measured silence 
     \ against incoming nsec.  It is used to calibrate nsec whenever
     \ this word runs:
      {"   nsec     meas
          0.0100   0.0208
          0.1000   0.1083
          0.2000   0.2095 \ this one is fudged a bit; test seemed off
          1.0000   1.0770
          2.0000   2.0399
          4.0000   4.2247
          10.0000  10.3026
      "} 2 matread push
         peek 1st catch (X) dup (X) pull 2nd catch (Y) / (X/Y)
         (X Y) park "XY" book
      ]
    \ Use table XY to calibrate incoming nsec:
      XY over lerp * @ "nsec" book "H" book

      bSilence export1 (byte)

      H nSamplesPerSec pry H wBitsPerSample pry * (bits/sec)
      (bits/sec) nsec * (bits) 8 / (nbytes)

      0.5 + integer dup 2 mod + (nbytes) \ require even integer

      (byte nbytes) cats hand (hT)
   end

   inline: wavTime (qS --- sec) \ time to play wave file S
      (qS) dup file? 
      IF (qS) old binary "HND" file 
         HND fsize (bytes) HND wavHdr 9 ndx pry (bytes/sec) / (sec)
         HND fclose 
      ELSE \ return sec=0 if file not found:
         (qS) " wavTime: file not found " swap + . nl 0
      THEN
   end

{  Some tones and beeps (author's machine).

   ARCH "ting.wav" + wavData swap \ about 663 Hz
   LITTLE_ENDIAN import2 2 * LITTLE_ENDIAN export2 \ 2*amplitude
   10 clone over .1 wavSilence + swap wavFile1 wavPlayb

   ARCH "ringmod.wav" + wavData swap 80 tstrip 10 clone swap
   (hT hH) wavFile1 wavPlayb

   ARCH "Pageboy.wav" + wavData (hT hH) 
   swap 2 clone over .5 wavSilence + swap wavFile1 wavPlayb

   128 "wavSilence" "bSilence" bank
   ARCH "nokia-sms.wav" + wavData swap over 1 wavSilence + 
   5 clone swap (hT hH) wavFile1 wavPlayb
   0 "wavSilence" "bSilence" bank

   128 "wavSilence" "bSilence" bank
   ARCH "misslebeep3.wav" + wavData swap 80 tstrip over .5 wavSilence +
   5 clone swap (hT hH) wavFile1 wavPlayb
   0 "wavSilence" "bSilence" bank

   128 "wavSilence" "bSilence" bank
   ARCH "Minipiep.wav" + wavData swap over 1.5 wavSilence +
   5 clone swap (hT hH) wavFile1 wavPlayb
   0 "wavSilence" "bSilence" bank

   128 "wavSilence" "bSilence" bank
   ARCH "INNERMK.WAV" + wavData swap over 1 wavSilence +
   5 clone over .1 wavSilence + swap (hT hH) wavFile1 wavPlayb
   0 "wavSilence" "bSilence" bank
}
   private halt

\-----------------------------------------------------------------------

{  International Morse Code.  February 2008.

   Notes from Wikipedia:
      1. A dash is equal to three dots.
      2. The space between parts of the same letter is equal to one dot.
      3. The space between two letters is equal to three dots.
      4. The space between two words is equal to five dots.
}
   LOAD MORSE CODE

{  Words.

   Making DIT and DAH.

      Make tones of a reference frequency (to be set below) at 11025 
      samples per second.  Use 16 bit samples, and set amplitude to 
      max 16-bit signed number, 32767.

      Wave file header HDR incorporates the reference frequency at the
      sample rate of 11025 to make DIT and DAH and assemble them into 
      the letter codes.

      Then when playing codes, HDR2 with a higher sampling rate is used 
      to speed things up.  A 22050 sample per second rate isn't bad once
      the codes become familiar.  
}
      32767 "A" book \ sound amplitude
      11025 "S" book \ sample rate when making DIT, DAH and codes

    \ 22050 "W" book \ higher sample rate for playing codes
    \ 27420 "W" book \ higher rate
    \ 33075 "W" book \ higher rate
    \ 37800 "W" book \ higher rate
      44100 "W" book \ higher rate
{
      Setting reference frequency: put yes on the stack for high 
      pitched, no for moderate.  

      Note that frequency is separate from sample rate; sample rate 
      governs the speed of the dits and dahs but not the frequency 
      (pitch or tone) at which they are heard:
}  
      "LOAD_MORSE_CODE" "SHRILL" yank (f equal to yes or no)
      (f)
      IF 1760  \ 1760 Hz (key A6 on piano)
      ELSE 880 \ 880 Hz (key A5 on piano)
      THEN 
      (Hz) S * W / "F" book \ frequency of tones for making DIT and DAH

\     Basic wave file headers, filled in by wavFile1:
      "0 16 'S' main wavHeader1" "HDR"  macro \ for making
      "0 16 'W' main wavHeader1" "HDR2" macro \ for playing

\     Making DIT: 0.1 second tone and 0.1 second silence:
      F 0.1 S pTone A * LITTLE_ENDIAN export2 (hT)
      (hT) HDR .1 wavSilence + (hT) "DIT" book

\     Making DAH: 0.5 second tone and 0.1 second silence:
      F 0.5 S pTone A * LITTLE_ENDIAN export2 (hT)
      (hT) HDR .1 wavSilence + (hT) "DAH" book

{     Testing DIT and DAH:

      Note: for this test to be valid, place word halt just above
      this point so DIT and DAH in their present states are used
      when the phrases below are copied at the ready prompt.

      DIT 10 clone HDR wavFile1 time push wavPlayf time pull - 10 /
       0 number: 0.205973005295
       1 number: 0.206087493896
       2 number: 0.205363702774
       3 number: 0.20708899498
       4 number: 0.207250905037

      DAH 10 clone HDR wavFile1 time push wavPlayf time pull - 10 /
       0 number: 0.604858207703
       1 number: 0.606989407539
       2 number: 0.607045197487
       3 number: 0.606985521317
       4 number: 0.607009601593

      DAH is about three times as long as DIT, as specified in note 1
      above.

      Here are numbers in HDR after wavData() fixes it up for DIT:
         DIT HDR wavFile1 (qFile) wavData (hT hH) bend itext neat . drop
 
         0 4276 0 0 16 1 1 11025 22050 1 16 0 4162

      and here are numbers in HDR2 for DIT when W = 22050:
         DIT HDR2 wavFile1 (qFile) wavData bend itext neat . drop

         0 4276 0 0 16 1 1 22050 44100 1 16 0 4162

      Zeroes are at elements that are not numbers (like "RIFF" in the 
      first four bytes); the eighth element is the sample rate.
 
   In note 2 above, the space between DAH and DIT in the same letter is
   equal to DIT, which is 0.21 seconds.  Make it 0.3 seconds for novices
   like us:
} \ HDR 0.3 wavSilence "DSI" book \ DSI is DIT*1.5 

\  Later: reduce DSI to 0.2 seconds, about the duration of DIT; LSI
\  and WSI will be reduced accordingly:
   HDR 0.2 wavSilence "DSI" book \ DSI is a DIT's worth of silence

{  Testing 0.3 second DSI
      DSI 10 clone HDR wavFile1 time push wavPlayf time pull - 10 /
       0 number: 0.303108906746
       1 number: 0.300655913353
       2 number: 0.300692105293
       3 number: 0.300739097595
       4 number: 0.30042078495

   Try DIT DAH, the letter A:
      Using some of the test times above, expect a time of about
      DIT + DAH = 0.206 + 0.606 = 0.812

      DIT DAH + 5 clone HDR wavFile1 time push wavPlayf time pull - 5 /
       0 number: 0.825079011917
       1 number: 0.825114583969
       2 number: 0.825066995621
       3 number: 0.825047206879
       4 number: 0.82513217926

      All the times look reasonable, and it is concluded that timing 
      is working correctly.

   Here is B A--it sounds pretty neat:
      DAH DIT DIT DIT + + + (B) DSI + 
      DIT DAH (A) + + DSI + HDR wavFile1 wavPlayf 
 
   In note 3 above, the space (silence) between two letters is equal 
   to three DITS, or 3*DSI:
}  "[ DSI 3 clone 'L' book ] L" "LSI" macro \ silence between letters

{  Testing LSI
      LSI 5 clone HDR wavFile1 time push wavPlayf time pull - 5 /
       0 number: 0.88948059082
       1 number: 0.889364433289
       2 number: 0.889290237427
       3 number: 0.889289808273
       4 number: 0.888630199432
 
   In note 4 above, the space between two words is equal to five DITS,
   or 5*DSI:
}  "[ DSI 5 clone 'W' book ] W" "WSI" macro \ silence between words

{  Testing WSI
      WSI 5 clone HDR wavFile1 time push wavPlayf time pull - 5 /
       0 number: 1.45616002083
       1 number: 1.45600438118
       2 number: 1.45607757568
       3 number: 1.45609302521
       4 number: 1.45592041016
}
\  DIT and DAH with a dash means they are followed by DSI silence:
   DIT DSI + "DIT-" book \ DIT followed by DSI silence
   DAH DSI + "DAH-" book \ DAH followed by DSI silence

\  Making the code:
   inline: CODE (qL --- hS) \ sounds for Morse code
{     For character L, return its sound bytes in Morse code. 

      Symbol * is used in the names because plain numbers cannot be
      names.
}     [ (0) DAH- DAH- DAH- DAH- DAH + + + + "0*" book
        (1) DIT- DAH- DAH- DAH- DAH + + + + "1*" book
        (2) DIT- DIT- DAH- DAH- DAH + + + + "2*" book
        (3) DIT- DIT- DIT- DAH- DAH + + + + "3*" book
        (4) DIT- DIT- DIT- DIT- DAH + + + + "4*" book
        (5) DIT- DIT- DIT- DIT- DIT + + + + "5*" book
        (6) DAH- DIT- DIT- DIT- DIT + + + + "6*" book
        (7) DAH- DAH- DIT- DIT- DIT + + + + "7*" book
        (8) DAH- DAH- DAH- DIT- DIT + + + + "8*" book
        (9) DAH- DAH- DAH- DAH- DIT + + + + "9*" book
        (A) DIT- DAH +                      "A*" book
        (B) DAH- DIT- DIT- DIT + + +        "B*" book
        (C) DAH- DIT- DAH- DIT + + +        "C*" book
        (D) DAH- DIT- DIT + +               "D*" book
        (E) DIT                             "E*" book
        (F) DIT- DIT- DAH- DIT + + +        "F*" book
        (G) DAH- DAH- DIT + +               "G*" book 
        (H) DIT- DIT- DIT- DIT + + +        "H*" book 
        (I) DIT- DIT +                      "I*" book 
        (J) DIT- DAH- DAH- DAH + + +        "J*" book 
        (K) DAH- DIT- DAH + +               "K*" book 
        (L) DIT- DAH- DIT- DIT + + +        "L*" book
        (M) DAH- DAH +                      "M*" book 
        (N) DAH- DIT +                      "N*" book
        (O) DAH- DAH- DAH + +               "O*" book
        (P) DIT- DAH- DAH- DIT + + +        "P*" book
        (Q) DAH- DAH- DIT- DAH + + +        "Q*" book
        (R) DIT- DAH- DIT + +               "R*" book
        (S) DIT- DIT- DIT + +               "S*" book
        (T) DAH                             "T*" book
        (U) DIT- DIT- DAH + +               "U*" book
        (V) DIT- DIT- DIT- DAH + + +        "V*" book
        (W) DIT- DAH- DAH + +               "W*" book
        (X) DAH- DIT- DIT- DAH + + +        "X*" book
        (Y) DAH- DIT- DAH- DAH + + +        "Y*" book
        (Z) DAH- DAH- DIT- DIT + + +        "Z*" book
      ] (qL) uppercase "*" + local
   end

   inline: mc ( --- ) \ practice Morse code
      [ "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890" "L" book
         2 "N" book
         2 "s1" book
         HDR2 "H" book
      ] 
      1 "i" book
      0 "s" book
      "Press a key to quit" . nl
      BEGIN 
         s getch1 (nC) 0=
         IF L i ndx character spaced N cats WORDS WSI + H wavFile1
            L i ndx character . dup wavPlayf delete
            1 i bump
            s1 "s" book
            false
         ELSE true
         THEN
         (f) i L strlen > or
      UNTIL
   end

   inline: mcslow ( --- ) \ practice Morse code
      HDR "mc" "H" bank mc HDR "mc" "H" bank
   end

   inline: SIG (qSIG n --- qWAV) \ qSIG repeated n times
      (n) push (qSIG) WORDS WSI + pull clone WSI + HDR2 wavFile1 
   end

   inline: WORD (qW --- hM) \ Morse code for word W
      strchop "W" book "" W chars 1st
      DO W I character CODE LSI + + LOOP
   end

   inline: WORDS (qT --- hM) \ Morse code for words in T
       words "T" book "" T rows 1st
       DO T I pry WORD WSI + + LOOP
   end
   
{  Playing a code or two:

      'A' CODE HDR2 wavFile1 wavPlayb \ dit dah
      'Z' CODE HDR2 wavFile1 wavPlayb \ dah dah dit dit

      'C' CODE LSI + 'Q' CODE + HDR2 wavFile1 wavPlayb

    \ SOS 3 times (using letter silence and word silence):      
      'S' CODE LSI + 'O' CODE LSI + over + + WSI +
      3 clone HDR2 wavFile1 wavPlayb

    \ It grows on you after a while, kind of a neat ditty:
      "Now is the time for all good men to come to the aid of "
      "their party" + WORDS HDR2 wavFile1 \ HDR2 at 48000 s/sec
      dup wavTime push time push dup wavPlayf delete time pull - pull 
 
{     When done, times on stack should agree.  The one on top does
      not include the overhead to start the shell command in word
      wavPlayf(), and so it should be smaller.

      For 48000 samples/sec and DSI = 3 * DIT:
         stack elements:
               0 number: 62.6862083333
               1 number: 62.7972939014
}
    \ This plays every letter in the alphabet:
      "The quick brown fox jumped over the lazy dogs"
      WORDS HDR2 wavFile1 dup wavTime push \ HDR2 at 48000 s/sec
      time push dup wavPlayf delete time pull - pull 

{     For 48000 samples/sec and DSI = 3 * DIT:
         stack elements:
               0 number: 48.6746041667
               1 number: 48.8284301758
}
   Analysis of DIT and DAH signals:

      "wPSD" missing IF "signal.v" source THEN

      HDR2 "HDRX" book
    \ DIT LITTLE_ENDIAN import2 (hA)
      DAH LITTLE_ENDIAN import2 (hA)

      (hA) "A" book                       \ signal amplitudes
      HDRX 8 pry "S" book                 \ sample rate
      one S slash, A rows uniform makes t \ times

   \  Shows signal followed by silence:
      A t plot                            

   \  Closeup shows signal:
      A 1st 500 items reach  
      t 1st 500 items reach plot
   
   \  PSD shows 1524 Hz signal using HDR2, the fast one:
      A S A rows wPSD (hPSD hF) \ first row is for F=0
      2nd over rows 1- items reach "F" book \ remove 0 for log function
      2nd over rows 1- items reach "PSD" book

    \ Log-log plot:
      PSD log10 F log10 plot \ spike at about 3.183: 3.183 10^ = 1524 Hz

    \ Semi-log plot:
      PSD log10 F plot \ spike at about 1524 Hz in semilog plot

      plotclose
}
   private halt

\-----------------------------------------------------------------------

;  Appendix

\  Some sound studies in March 2003.

\  Working in /home/dale/sound (or /usr/local/sound).

"wavData" missing IF "snd.v" source THEN
"sayit" missing IF "say.v" source THEN

I. Learning how to interpret bytes in a .wav sound file.

   The following tests establish that 16 bit/sample, 16 kHz data should
   be treated as signed 2-byte integers, while 8 bit/sample, 8 kHz data
   should be taken as unsigned 1-byte integers.

Using .wav files obtained from the Festival project:

   http://www-2.cs.cmu.edu/~awb/festival_demos/index.html

Looking at bytes in a .wav file with 16 bits/sample at 16 kHz.  

Using word wav>au to echo the header:
[tops@clacker] ready > 'gen_fest1.wav' wav>au
Reading Wave file: Microsoft PCM format, 1 channel, 16000 samp/sec
32000 byte/sec, 2 block align, 16 bits/samp, 123524 data bytes

[tops@clacker] ready > 'gen_fest1.wav' wavData

 stack elements:
       0 matrix: _list  13 by 1
       1 volume: _fget  1 by 123524
 [2] ok!
[tops@clacker] ready > drop

 stack elements:
       0 volume: _fget  1 by 123524
 [1] ok!
[tops@clacker] ready > dup LITTLE_ENDIAN import2

 stack elements:
       0 matrix: _import2  61762 by 1
       1 volume: _fget  1 by 123524
 [2] ok!
[tops@clacker] ready > swap LITTLE_ENDIAN uimport2

 stack elements:
       0 matrix: _uimport2  61762 by 1
       1 matrix: _import2  61762 by 1
 [2] ok!
[tops@clacker] ready > park 1st 2000 items reach iview 
Here are sample values at a point where it seems obvious that the data
is 2-byte signed as obtained from import2:

            import2  uimport2
 Row 944:        0        0
 Row 945:        0        0
 Row 946:       -7    65529
 Row 947:        0        0
 Row 948:       -4    65532
 Row 949:       -2    65534
 Row 950:       -4    65532
 Row 951:       -4    65532
 Row 952:        3        3
 Row 953:        3        3
 Row 954:        3        3
 Row 955:        5        5
 Row 956:       16       16
 Row 957:       18       18
 Row 958:       13       13
 Row 959:       16       16
 Row 960:       13       13
 Row 961:       23       23
 Row 962:        8        8
 Row 963:       13       13
 Row 964:       10       10
 Row 965:        8        8
 Row 966:        8        8
 Row 967:        5        5
 Row 968:        8        8
 Row 969:        5        5
 Row 970:        8        8

The following test lets your ears confirm that signed integers is the 
way to interpret these 16 bit sound bytes, as they are read, amplified 
by 50%, and played:

   'gen_fest1.wav' wavData drop dup
   LITTLE_ENDIAN uimport2 1.5 *f LITTLE_ENDIAN export2 16 16 play1
   LITTLE_ENDIAN import2  1.5 *f LITTLE_ENDIAN export2 16 16 play1


Looking at bytes in a .wav file with 8 bits/sample at 8 kHz.  

[tops@clacker] ready > 'gen_fest.fem.wav' wav>au
Reading Wave file: Microsoft PCM format, 1 channel, 8000 samp/sec
8000 byte/sec, 1 block align, 8 bits/samp, 19004 data bytes

[tops@clacker] ready > 'gen_fest.fem.wav' wavData drop

 stack elements:

       0 volume: _fget  1 by 19004
 [1] ok!
[tops@clacker] ready > dup import1              

       0 matrix: _import1  19004 by 1
       1 volume: _fget  1 by 19004
 [2] ok!
[tops@clacker] ready > swap uimport1

 stack elements:
       0 matrix: _uimport1  19004 by 1
       1 matrix: _import1  19004 by 1
 [2] ok!
[tops@clacker] ready > park iview

Viewing some of the sound bytes:

            import1   uimport1
 Row 2573:      122      122
 Row 2574:      124      124
 Row 2575:      126      126
 Row 2576:     -128      128
 Row 2577:     -125      131
 Row 2578:     -123      133
 Row 2579:     -121      135
 Row 2580:     -119      137
 Row 2581:     -120      136
 Row 2582:     -122      134
 Row 2583:     -127      129
 Row 2584:      123      123
 Row 2585:      118      118
 Row 2586:      115      115
 Row 2587:      115      115
 Row 2588:      117      117
 Row 2589:      122      122
 Row 2590:      126      126
 Row 2591:     -124      132
 Row 2592:     -119      137
 Row 2593:     -114      142
 Row 2594:     -110      146
 Row 2595:     -106      150

The signed values from import1 go through drastic changes and are fully
saturated (-128 to +127).  The unsigned values are not that way, and are
in the middle of the 0 to 255 range.

The following sound test confirms that unsigned is the way to interpret
these 8 bit sound bytes, as they are read, amplified by 50%, and played:

   'gen_fest.fem.wav' wavData drop dup
   import1  1.5 *f export1 8 8000 play1
   uimport1 1.5 *f export1 8 8000 play1

II. Resampling 16 bit, 16 kHz sound bytes to create 8 bit, 9.6 kHz
sound bytes.

   To run this region, place the name of a 16 bit, 16 kHz .wav file
   in the quotes below and then run this phrase:

      "snd.v" "RESAMPLE" msource

   RESAMPLE "intro.wav" is WAV16bit@16kHz

   "resample" missing IF "signal.v" source THEN
   "wavData" missing IF "snd.v" source THEN
   "sayit" missing IF "say.v" source THEN

   WAV16bit@16kHz wavData drop \ 16 bit, 16 kHz data

\  Playing the original:
   (hT) dup 16 16000 play1

\  Resampling at 9600 Hz (to hear the ill effects from not low pass 
\  filtering when resampling, try word resample1 in the next line):
   (hT) LITTLE_ENDIAN import2 pad2 16000 9600 resample (hA)

\  Playing 16 bit data resampled at 9600 Hz:
   (hA) dup LITTLE_ENDIAN export2 (hT) 16 9600 play1

\  Scaling resampled 16 bit data to 8 bits per sample:
   list: -32768 32767 ; \ signed 2-byte ints
   list: 0      255   ; \ into unsigned 1-byte ints
   park (hXY) \ table for word lerp

   (hA hXY) swap lerp integer (hA)

\  Playing scaled 8 bit, 9600 Hz:
   (hA) export1 (hT) 8 9600 play1

   private halt

   In this next case, the data is first reduced to 8 bits per sample 
   and then it is resampled at 9600 Hz.  The result is not as good as 
   the previous case (the third one played) where resampling is done 
   first, followed by reduction to 8 bits.
   Is it possible that resampling makes some values exceed a 1-byte
   value?

   To run the code in this region, use the phrase:

      "snd.v" "RESAMPLE1" msource

   RESAMPLE1 "intro.wav" is WAV16bit@16kHz

   "resample" missing IF "signal.v" source THEN
   "wavData" missing IF "snd.v" source THEN
   "sayit" missing IF "say.v" source THEN
   
   WAV16bit@16kHz wavData drop \ 16 bit, 16 kHz data
   
\  Playing the original:
   (hT) dup 16 16000 play1
   
\  Scaling the 16 bit data to 8 bits per sample:
   (hT) LITTLE_ENDIAN import2 (hA)
   list: -32768 32767 ; \ signed 2-byte ints
   list: 0      255   ; \ into unsigned 1-byte ints
   park (hXY) \ table for word lerp

   (hA hXY) swap integer lerp integer (hA)

\  Resampling at 9600 Hz:
   (hA) pad2 16000 9600 resample (hA)
   
\  Playing scaled 8 bit, 9600 Hz:
   (hA) export1 (hT) 8 9600 play1

   private halt

III. Resampling 8 bit, 8 kHz sound bytes to create 8 bit, 9.6 kHz sound
bytes.

   To run the code in this region, use the phrase:

      "snd.v" "RESAMPLE1" msource

   RESAMPLE2 "gen_fest.fem.wav" is WAV8bit@8kHz

   "resample" missing IF "signal.v" source THEN
   "wavData" missing IF "snd.v" source THEN
   "sayit" missing IF "say.v" source THEN

   WAV8bit@8kHz wavData drop \ 8 bit, 8 kHz data

\  Playing the original:
   (hT) dup 8 8000 play1
   
\  Fitting a cubic spline to the points at 8 kHz, and then creating
\  data at 9.6 kHz:
   (hT) uimport1 (hA)
   (hA) one 8000 slash those rows uniform s3coef (hC)
   one 9600 slash those rows 9.6 8.0 / * uniform s3eval 2drop (hA)

\  Playing new 8 bit data at 9600 Hz:
   (hA) export1 (hT) 8 9600 play1

   private halt

\-----------------------------------------------------------------------

\  Some sound tests in December 2000.

   "plot" missing IF plot.v source THEN
   "quantize" missing IF math.v source THEN

   LITTLE_ENDIAN is ENDIAN

   "AU" missing
   IF
      "au" closeif
      "/home/dale/sound/oss/sndkit/dsp/sample.au" old binary "au" file

      au dup rewind, its file.size pry fget, ENDIAN import2 into AU 

      \ Taking first 128000 bytes of data from sample.au:
      AU 1st those rows 672 128 / / items those rows teeth rake
      drop into AU

      \ Interpreting sound data as unsigned:
      au dup rewind, its file.size pry fget, ENDIAN uimport2 into uAU 
      uAU 1st those rows 672 128 / / items those rows teeth rake
      drop into uAU

      "au1.au" dup deleteif new binary "au1" dup closeif file
      AU ENDIAN export2 au1 dup rewind fput
      "/usr/local/bin/splay -t 8 -b 16 -s 8 au1.au" shell
   THEN
\-----------------------------------------------------------------------

   halt

\  In the tests of quantizing below, case b) (signed values) has much 
\  less noise.  Yet it is difficult to hear any difference between
\  each of the unquantized vectors, AU and uAU. 

\  a) using unsigned values:
   uAU maxfetch 2drop uAU minfetch 2drop abs max
   10 / 10 uniform
   uAU quantize "uAUq" book
   uAUq "au1.au" dup deleteif new binary "au1" dup closeif file
   ENDIAN export2 au1 dup rewind fput
   "/usr/local/bin/splay -t 8 -b 16 -s 8 au1.au" shell

\  b) using signed values:
   AU maxfetch 2drop AU minfetch 2drop abs max
   10 / 10 uniform
   AU quantize 10 *f "AUq" book \ increase gain by factor of 10
   AUq "au1.au" dup deleteif new binary "au1" dup closeif file
   ENDIAN export2 au1 dup rewind fput
   "/usr/local/bin/splay -t 8 -b 16 -s 8 au1.au" shell

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  These are two versions of word "testing:"
   100 is M
   AU 36129 M items reach                 
   AU 7550  M items reach negate                
   park 1st those rows items plot

\  Here's just the word "testing:"
   AU 36129 4505 items reach                 
   AU 7352 4505 items reach                 
   "au1.au" dup deleteif new binary "au1" dup closeif file
   ENDIAN export2 au1 dup rewind fput 
   "/usr/local/bin/splay -t 8 -b 16 -s 8 au1.au" shell

\  Here's just the word "testing:"
   AU maxfetch 2drop AU minfetch 2drop abs max
   1st swap items these rows 64 spikes rake lop
   AU abs quantize integer 4 *f "AUq" book
   AUq list: 36129 40634 thru ; reach                 
   "au1.au" dup deleteif new binary "au1" dup closeif file
   ENDIAN export2 au1 dup rewind fput 

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  Even after using absolute value and quantizing to about 10 levels,
\  the words can still be understood:
   AU maxfetch 2drop AU minfetch 2drop abs max
   1st swap items these rows 128 spikes rake lop
   AU abs quantize dup "AUq" book
   "au1.au" dup deleteif new binary "au1" dup closeif file
   ENDIAN export2 au1 dup rewind fput 
   "/usr/local/bin/splay -t 8 -b 16 -s 8 au1.au" shell

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -
 
\  Moving average doesn't drop the peaks that much (maybe 10%) but
\  the volume goes way down.  Scaling everything up, maybe by factor
\  of 4, brings volume back.

   AU 64 ma (these rows 4 spikes rake lop) dup into AU1
   ENDIAN export2 au1 dup rewind fput 

\  Raising or lowering the volume by scaling (*f or /f): 
   "au1.au" dup deleteif new binary "au1" dup closeif file
   AU 4 *f ENDIAN export2 au1 dup rewind fput
   "/usr/local/bin/splay -t 8 -b 16 -s 8 au1.au" shell
 
\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  Moving average filter and take every 4th one.  It plays fast
\  because -s can't be set to 2 (kHz)--4 kHz is the lowest.
   AU 16 ma these rows 4 spikes rake lop dup into AU1
   "au1.au" dup deleteif new binary "au1" dup closeif file
   ENDIAN export2 au1 fput 
   "/usr/local/bin/splay -t 8 -b 16 -s 4 au1.au" shell
 

   AU its rows 2 spikes rake lop ENDIAN export2 au1 fput 

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  Plotting every tenth point
   ten is N 
   AU N those rows N / uniform N +d reach 
   1st those rows items plot
 

\-----------------------------------------------------------------------

   Obsolete.

  _inline: auHeaderFake (qFile --- qFileAu) \ forcing 9600 Hz in header
      [ no 'au' book
        "_bin" "tmppath" yank runid cat "aufake" cat makes FAKE
      ]
      au filetrue IF au fclose THEN

      (qFile) old binary "au" file
      au again rewind, its file.size pry fget (hT)

      FAKE deleteif
      0 1 9600 auHeader FAKE auWrite
      au fclose
      FAKE
   end

   




